/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.SparkEntity;

public abstract class SparkBaseEntity
extends Entity
implements SparkEntity {
    private static final String TAG_INVIS = "invis";
    private static final String TAG_NETWORK = "network";
    private static final EntityDataAccessor<Integer> NETWORK = SynchedEntityData.defineId(SparkBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SparkBaseEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(NETWORK, (Object)0);
    }

    @Override
    public BlockPos getAttachPos() {
        int x = Mth.floor((double)this.getX());
        int y = Mth.floor((double)(this.getY() - 1.0));
        int z = Mth.floor((double)this.getZ());
        return new BlockPos(x, y, z);
    }

    @Override
    public DyeColor getNetwork() {
        return DyeColor.byId((int)((Integer)this.entityData.get(NETWORK)));
    }

    @Override
    public void setNetwork(DyeColor color) {
        this.entityData.set(NETWORK, (Object)color.getId());
    }

    public boolean isPickable() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setInvisible(compound.getBoolean(TAG_INVIS));
        this.setNetwork(DyeColor.byId((int)compound.getInt(TAG_NETWORK)));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean(TAG_INVIS, this.isInvisible());
        compound.putInt(TAG_NETWORK, this.getNetwork().getId());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }
}

