/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaBurstEntity
extends ThrowableProjectile
implements ManaBurst {
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA = "mana";
    private static final String TAG_STARTING_MANA = "startingMana";
    private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
    private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_LENS_STACK = "lensStack";
    private static final String TAG_HAS_SHOOTER = "hasShooter";
    private static final String TAG_SHOOTER = "shooterUUID";
    private static final String TAG_LAST_COLLISION_X = "lastCollisionX";
    private static final String TAG_LAST_COLLISION_Y = "lastCollisionY";
    private static final String TAG_LAST_COLLISION_Z = "lastCollisionZ";
    private static final String TAG_WARPED = "warped";
    private static final String TAG_ORBIT_TIME = "orbitTime";
    private static final String TAG_TRIPPED = "tripped";
    private static final String TAG_MAGNETIZE_POS = "magnetizePos";
    private static final String TAG_LEFT_SOURCE = "leftSource";
    private static final String TAG_ALREADY_COLLIDED_AT = "alreadyCollidedAt";
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MANA = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> START_MANA = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MIN_MANA_LOSS = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> MANA_LOSS_PER_TICK = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<BlockPos> SOURCE_COORDS = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<ItemStack> SOURCE_LENS = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> LEFT_SOURCE_POS = SynchedEntityData.defineId(ManaBurstEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float accumulatedManaLoss = 0.0f;
    private boolean fake = false;
    private final Set<BlockPos> alreadyCollidedAt = new HashSet<BlockPos>();
    private boolean fullManaLastTick = true;
    @Nullable
    private UUID shooterIdentity = null;
    private int _ticksExisted = 0;
    private boolean scanBeam = false;
    @Nullable
    private BlockPos lastCollision;
    private boolean warped = false;
    private int orbitTime = 0;
    private boolean tripped = false;
    @Nullable
    private BlockPos magnetizePos = null;
    public final List<PositionProperties> propsList = new ArrayList<PositionProperties>();
    @Nullable
    private ManaReceiver collidedTile = null;
    private boolean noParticles = false;

    public ManaBurstEntity(EntityType<ManaBurstEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR, (Object)0);
        builder.define(MANA, (Object)0);
        builder.define(START_MANA, (Object)0);
        builder.define(MIN_MANA_LOSS, (Object)0);
        builder.define(MANA_LOSS_PER_TICK, (Object)Float.valueOf(0.0f));
        builder.define(GRAVITY, (Object)Float.valueOf(0.0f));
        builder.define(SOURCE_COORDS, (Object)ManaBurst.NO_SOURCE);
        builder.define(SOURCE_LENS, (Object)ItemStack.EMPTY);
        builder.define(LEFT_SOURCE_POS, (Object)false);
    }

    public static Vec3 calculateBurstVelocity(float xRot, float yRot) {
        float f = 0.4f;
        double mx = (double)(Mth.sin((float)(yRot / 180.0f * (float)Math.PI)) * Mth.cos((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(Mth.cos((float)(yRot / 180.0f * (float)Math.PI)) * Mth.cos((float)(xRot / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(Mth.sin((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        return new Vec3(mx, my, mz);
    }

    public ManaBurstEntity(Level level, BlockPos pos, float rotX, float rotY, boolean fake) {
        this(BotaniaEntities.MANA_BURST, level);
        this.fake = fake;
        this.setBurstSourceCoords(pos);
        this.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.4990234375, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        this.setYRot(-(rotX + 90.0f));
        this.setXRot(rotY);
        this.setDeltaMovement(ManaBurstEntity.calculateBurstVelocity(this.getXRot(), this.getYRot()));
    }

    public ManaBurstEntity(Player player) {
        super(BotaniaEntities.MANA_BURST, (LivingEntity)player, player.level());
        this.setBurstSourceCoords(NO_SOURCE);
        this.setRot(player.getYRot() + 180.0f, -player.getXRot());
        this.setDeltaMovement(ManaBurstEntity.calculateBurstVelocity(this.getXRot(), this.getYRot()));
    }

    public void tick() {
        LensEffectItem lens;
        this.setTicksExisted(this.getTicksExisted() + 1);
        if (!(this.level().isClientSide && !this.fake || this.hasLeftSource() || this.blockPosition().equals((Object)this.getBurstSourceBlockPos()))) {
            this.entityData.set(LEFT_SOURCE_POS, (Object)true);
        }
        super.tick();
        if (!this.fake && this.isAlive() && !this.scanBeam) {
            this.ping();
        }
        if ((lens = this.getLensInstance()) != null) {
            lens.updateBurst(this, this.getSourceLens());
        }
        int mana = this.getMana();
        if (this.getTicksExisted() >= this.getMinManaLoss()) {
            this.accumulatedManaLoss += this.getManaLossPerTick();
            int loss = (int)this.accumulatedManaLoss;
            this.setMana(mana - loss);
            this.accumulatedManaLoss -= (float)loss;
            if (this.getMana() <= 0) {
                this.discard();
            }
        }
        this.particles();
        boolean bl = this.fullManaLastTick = this.getMana() == this.getStartingMana();
        if (this.scanBeam) {
            PositionProperties props = PositionProperties.fromEntity((Entity)this);
            if (this.propsList.isEmpty()) {
                this.propsList.add(props);
            } else {
                PositionProperties lastProps = this.propsList.getLast();
                if (!props.coordsEqual(lastProps)) {
                    this.propsList.add(props);
                }
            }
        }
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> fluid, double mag) {
        return false;
    }

    public boolean isInLava() {
        return false;
    }

    @Nullable
    public ManaReceiver getCollidedTile(boolean noParticles) {
        this.noParticles = noParticles;
        for (int iterations = 0; this.isAlive() && iterations < BotaniaConfig.common().spreaderTraceTime(); ++iterations) {
            this.tick();
        }
        if (this.fake) {
            this.incrementFakeParticleTick();
        }
        return this.collidedTile;
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return !this.fake;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        UUID identity;
        super.addAdditionalSaveData(tag);
        if (this.fake) {
            String msg = String.format("Fake bursts should never be saved at any time! Source pos %s, owner %s", this.getBurstSourceBlockPos(), this.getOwner());
            throw new IllegalStateException(msg);
        }
        tag.putInt(TAG_TICKS_EXISTED, this.getTicksExisted());
        tag.putInt(TAG_COLOR, this.getColor());
        tag.putInt(TAG_MANA, this.getMana());
        tag.putInt(TAG_STARTING_MANA, this.getStartingMana());
        tag.putInt(TAG_MIN_MANA_LOSS, this.getMinManaLoss());
        tag.putFloat(TAG_TICK_MANA_LOSS, this.getManaLossPerTick());
        tag.putFloat(TAG_GRAVITY, this.getBurstGravity());
        ItemStack stack = this.getSourceLens();
        CompoundTag lensCmp = new CompoundTag();
        if (!stack.isEmpty()) {
            lensCmp = stack.save((HolderLookup.Provider)this.level().registryAccess());
        }
        tag.put(TAG_LENS_STACK, (Tag)lensCmp);
        BlockPos coords = this.getBurstSourceBlockPos();
        tag.putInt(TAG_SPREADER_X, coords.getX());
        tag.putInt(TAG_SPREADER_Y, coords.getY());
        tag.putInt(TAG_SPREADER_Z, coords.getZ());
        if (this.lastCollision != null) {
            tag.putInt(TAG_LAST_COLLISION_X, this.lastCollision.getX());
            tag.putInt(TAG_LAST_COLLISION_Y, this.lastCollision.getY());
            tag.putInt(TAG_LAST_COLLISION_Z, this.lastCollision.getZ());
        }
        boolean hasShooter = (identity = this.getShooterUUID()) != null;
        tag.putBoolean(TAG_HAS_SHOOTER, hasShooter);
        if (hasShooter) {
            tag.putUUID(TAG_SHOOTER, identity);
        }
        tag.putBoolean(TAG_WARPED, this.warped);
        tag.putInt(TAG_ORBIT_TIME, this.orbitTime);
        tag.putBoolean(TAG_TRIPPED, this.tripped);
        if (this.magnetizePos != null) {
            tag.put(TAG_MAGNETIZE_POS, (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.magnetizePos).getOrThrow());
        }
        tag.putBoolean(TAG_LEFT_SOURCE, this.hasLeftSource());
        ListTag alreadyCollidedAt = new ListTag();
        for (BlockPos pos : this.alreadyCollidedAt) {
            alreadyCollidedAt.add((Object)((Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)pos).getOrThrow()));
        }
        tag.put(TAG_ALREADY_COLLIDED_AT, (Tag)alreadyCollidedAt);
    }

    public void readAdditionalSaveData(CompoundTag cmp) {
        UUID identity;
        UUID serializedUuid;
        super.readAdditionalSaveData(cmp);
        this.setTicksExisted(cmp.getInt(TAG_TICKS_EXISTED));
        this.setColor(cmp.getInt(TAG_COLOR));
        this.setMana(cmp.getInt(TAG_MANA));
        this.setStartingMana(cmp.getInt(TAG_STARTING_MANA));
        this.setMinManaLoss(cmp.getInt(TAG_MIN_MANA_LOSS));
        this.setManaLossPerTick(cmp.getFloat(TAG_TICK_MANA_LOSS));
        this.setGravity(cmp.getFloat(TAG_GRAVITY));
        CompoundTag lensCmp = cmp.getCompound(TAG_LENS_STACK);
        ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)lensCmp).orElse(ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            this.setSourceLens(stack);
        } else {
            this.setSourceLens(ItemStack.EMPTY);
        }
        int x = cmp.getInt(TAG_SPREADER_X);
        int y = cmp.getInt(TAG_SPREADER_Y);
        int z = cmp.getInt(TAG_SPREADER_Z);
        this.setBurstSourceCoords(new BlockPos(x, y, z));
        if (cmp.contains(TAG_LAST_COLLISION_X)) {
            x = cmp.getInt(TAG_LAST_COLLISION_X);
            y = cmp.getInt(TAG_LAST_COLLISION_Y);
            z = cmp.getInt(TAG_LAST_COLLISION_Z);
            this.lastCollision = new BlockPos(x, y, z);
        }
        ListTag motion = cmp.getList("Motion", 6);
        this.setDeltaMovement(motion.getDouble(0), motion.getDouble(1), motion.getDouble(2));
        boolean hasShooter = cmp.getBoolean(TAG_HAS_SHOOTER);
        if (hasShooter && !(serializedUuid = cmp.getUUID(TAG_SHOOTER)).equals(identity = this.getShooterUUID())) {
            this.setShooterUUID(serializedUuid);
        }
        this.warped = cmp.getBoolean(TAG_WARPED);
        this.orbitTime = cmp.getInt(TAG_ORBIT_TIME);
        this.tripped = cmp.getBoolean(TAG_TRIPPED);
        this.magnetizePos = cmp.contains(TAG_MAGNETIZE_POS) ? (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)cmp.get(TAG_MAGNETIZE_POS)).getOrThrow() : null;
        this.entityData.set(LEFT_SOURCE_POS, (Object)cmp.getBoolean(TAG_LEFT_SOURCE));
        this.alreadyCollidedAt.clear();
        for (Tag tag : cmp.getList(TAG_ALREADY_COLLIDED_AT, 11)) {
            Optional pos = BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result();
            pos.ifPresent(this.alreadyCollidedAt::add);
        }
    }

    public void particles() {
        float osize;
        if (!this.isAlive() || !this.level().isClientSide) {
            return;
        }
        LensEffectItem lens = this.getLensInstance();
        if (lens != null && !lens.doParticles(this, this.getSourceLens())) {
            return;
        }
        int color = this.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float size = osize = this.getParticleSize();
        if (this.fake) {
            if (this.getMana() == this.getStartingMana()) {
                size = 2.0f;
            } else if (this.fullManaLastTick) {
                size = 4.0f;
            }
            if (!this.noParticles && this.shouldDoFakeParticles()) {
                SparkleParticleData data = SparkleParticleData.fake(0.4f * size, r, g, b, 1);
                this.level().addParticle((ParticleOptions)data, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            boolean depth;
            Player player = Proxy.INSTANCE.getClientPlayer();
            boolean bl = depth = player == null || !ManaseerMonocleItem.hasMonocle((LivingEntity)player);
            if (BotaniaConfig.client().subtlePowerSystem()) {
                WispParticleData data = WispParticleData.wisp(0.1f * size, r, g, b, depth);
                Proxy.INSTANCE.addParticleForceNear(this.level(), data, this.getX(), this.getY(), this.getZ(), (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.01f);
            } else {
                WispParticleData data;
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double iterX = this.getX();
                double iterY = this.getY();
                double iterZ = this.getZ();
                Vec3 currentPos = this.position();
                Vec3 oldPos = new Vec3(this.xo, this.yo, this.zo);
                Vec3 diffVec = oldPos.subtract(currentPos);
                Vec3 diffVecNorm = diffVec.normalize();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.uuid.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    data = WispParticleData.wisp(0.2f * size, r, g, b, depth);
                    Proxy.INSTANCE.addParticleForceNear(this.level(), data, iterX, iterY, iterZ, (float)(-this.getDeltaMovement().x()) * 0.01f, (float)(-this.getDeltaMovement().y()) * 0.01f, (float)(-this.getDeltaMovement().z()) * 0.01f);
                    currentPos = new Vec3(iterX += diffVecNorm.x * distance, iterY += diffVecNorm.y * distance, iterZ += diffVecNorm.z * distance);
                    diffVec = oldPos.subtract(currentPos);
                } while (this.getOrbitTime() <= 0 && Math.abs(diffVec.length()) > distance);
                data = WispParticleData.wisp(0.1f * size, or, og, ob, depth);
                this.level().addParticle((ParticleOptions)data, iterX, iterY, iterZ, (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f));
            }
        }
    }

    public void handleEntityEvent(byte event) {
        if (event == 3) {
            int color = this.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            int mana = this.getMana();
            int maxMana = this.getStartingMana();
            float size = (float)mana / (float)maxMana;
            if (!BotaniaConfig.client().subtlePowerSystem()) {
                for (int i = 0; i < 4; ++i) {
                    WispParticleData data = WispParticleData.wisp(0.15f * size, r, g, b);
                    this.level().addParticle((ParticleOptions)data, this.getX(), this.getY(), this.getZ(), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f));
                }
            }
            SparkleParticleData data = SparkleParticleData.sparkle(4.0f, r, g, b, 2);
            this.level().addParticle((ParticleOptions)data, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        } else {
            super.handleEntityEvent(event);
        }
    }

    public float getParticleSize() {
        return (float)this.getMana() / (float)this.getStartingMana();
    }

    protected void onHit(HitResult hit) {
        if (this.isFake()) {
            HitResult.Type type = hit.getType();
            if (type == HitResult.Type.ENTITY) {
                this.onHitEntity((EntityHitResult)hit);
            } else if (type == HitResult.Type.BLOCK) {
                this.onHitBlock((BlockHitResult)hit);
            }
        } else {
            super.onHit(hit);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult hit) {
        ManaTrigger trigger;
        ManaReceiver receiver;
        ManaCollisionGhost.Behaviour ghostBehaviour;
        BlockPos collidePos;
        if (!this.isFake()) {
            super.onHitBlock(hit);
        }
        if ((collidePos = hit.getBlockPos()).equals((Object)this.lastCollision)) {
            return;
        }
        this.lastCollision = collidePos.immutable();
        BlockEntity tile = this.level().getBlockEntity(collidePos);
        BlockState state = this.level().getBlockState(collidePos);
        Block block = state.getBlock();
        ManaCollisionGhost ghost = XplatAbstractions.INSTANCE.findManaGhost(this.level(), collidePos, state, tile);
        ManaCollisionGhost.Behaviour behaviour = ghostBehaviour = ghost != null ? ghost.getGhostBehaviour() : ManaCollisionGhost.Behaviour.RUN_ALL;
        if (ghostBehaviour == ManaCollisionGhost.Behaviour.SKIP_ALL || block instanceof BushBlock || block instanceof LeavesBlock) {
            return;
        }
        BlockPos sourcePos = this.getBurstSourceBlockPos();
        if (!this.hasLeftSource() && collidePos.equals((Object)sourcePos)) {
            return;
        }
        this.collidedTile = receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.level(), collidePos, state, tile, hit.getDirection());
        if (!this.fake && !this.noParticles && !this.level().isClientSide && receiver != null && receiver.canReceiveManaFromBursts() && this.onReceiverImpact(receiver)) {
            if (tile instanceof ThrottledPacket) {
                ThrottledPacket throttledPacket = (ThrottledPacket)tile;
                throttledPacket.markDispatchable();
            } else if (tile != null) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
        if ((trigger = XplatAbstractions.INSTANCE.findManaTrigger(this.level(), collidePos, state, tile)) != null) {
            trigger.onBurstCollision(this);
        }
        if (ghostBehaviour == ManaCollisionGhost.Behaviour.RUN_RECEIVER_TRIGGER) {
            return;
        }
        this.onHitCommon((HitResult)hit, true);
        this.setCollidedAt(collidePos);
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        super.onHitEntity(hit);
        this.onHitCommon((HitResult)hit, false);
    }

    private void onHitCommon(HitResult hit, boolean shouldKill) {
        LensEffectItem lens = this.getLensInstance();
        if (lens != null) {
            shouldKill = lens.collideBurst(this, hit, this.collidedTile != null && this.collidedTile.canReceiveManaFromBursts(), shouldKill, this.getSourceLens());
        }
        if (shouldKill && this.isAlive()) {
            if (this.fake) {
                this.discard();
            } else if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            }
        }
    }

    private boolean onReceiverImpact(ManaReceiver receiver) {
        if (this.hasWarped()) {
            return false;
        }
        LensEffectItem lens = this.getLensInstance();
        int mana = this.getMana();
        if (lens != null) {
            ItemStack stack = this.getSourceLens();
            mana = lens.getManaToTransfer(this, stack, receiver);
        }
        if (receiver instanceof ManaCollector) {
            ManaCollector collector = (ManaCollector)receiver;
            mana = (int)((float)mana * collector.getManaYieldMultiplier(this));
        }
        if (mana > 0) {
            receiver.receiveMana(mana);
            return true;
        }
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (!this.fake) {
            ManaSpreader spreader = this.getShooter();
            if (spreader != null && spreader.getIdentifier().equals(this.getShooterUUID())) {
                spreader.setCanShoot(true);
            }
        } else {
            this.setDeathTicksForFakeParticle();
        }
    }

    @Nullable
    private ManaSpreader getShooter() {
        ManaSpreader spreader;
        ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.level(), this.getBurstSourceBlockPos(), null);
        return receiver instanceof ManaSpreader ? (spreader = (ManaSpreader)receiver) : null;
    }

    public double getDefaultGravity() {
        return this.getBurstGravity();
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public void setScanBeam() {
        this.scanBeam = true;
    }

    @Override
    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    @Override
    public int getMana() {
        return (Integer)this.entityData.get(MANA);
    }

    @Override
    public void setMana(int mana) {
        this.entityData.set(MANA, (Object)mana);
    }

    @Override
    public int getStartingMana() {
        return (Integer)this.entityData.get(START_MANA);
    }

    @Override
    public void setStartingMana(int mana) {
        this.entityData.set(START_MANA, (Object)mana);
    }

    @Override
    public int getMinManaLoss() {
        return (Integer)this.entityData.get(MIN_MANA_LOSS);
    }

    @Override
    public void setMinManaLoss(int minManaLoss) {
        this.entityData.set(MIN_MANA_LOSS, (Object)minManaLoss);
    }

    @Override
    public float getManaLossPerTick() {
        return ((Float)this.entityData.get(MANA_LOSS_PER_TICK)).floatValue();
    }

    @Override
    public void setManaLossPerTick(float mana) {
        this.entityData.set(MANA_LOSS_PER_TICK, (Object)Float.valueOf(mana));
    }

    @Override
    public float getBurstGravity() {
        return ((Float)this.entityData.get(GRAVITY)).floatValue();
    }

    @Override
    public void setGravity(float gravity) {
        this.entityData.set(GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    public BlockPos getBurstSourceBlockPos() {
        return (BlockPos)this.entityData.get(SOURCE_COORDS);
    }

    @Override
    public void setBurstSourceCoords(BlockPos pos) {
        this.entityData.set(SOURCE_COORDS, (Object)pos);
    }

    @Override
    public ItemStack getSourceLens() {
        return (ItemStack)this.entityData.get(SOURCE_LENS);
    }

    @Override
    public void setSourceLens(ItemStack lens) {
        this.entityData.set(SOURCE_LENS, (Object)lens);
    }

    @Override
    public int getTicksExisted() {
        return this._ticksExisted;
    }

    @Override
    public boolean hasLeftSource() {
        return (Boolean)this.entityData.get(LEFT_SOURCE_POS);
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    @Nullable
    private LensEffectItem getLensInstance() {
        Item item;
        ItemStack lens = this.getSourceLens();
        if (!lens.isEmpty() && (item = lens.getItem()) instanceof LensEffectItem) {
            LensEffectItem effect = (LensEffectItem)item;
            return effect;
        }
        return null;
    }

    @Override
    public boolean hasAlreadyCollidedAt(BlockPos pos) {
        return this.alreadyCollidedAt.contains(pos);
    }

    @Override
    public void setCollidedAt(BlockPos pos) {
        if (!this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos.immutable());
        }
    }

    @Override
    public void setShooterUUID(UUID uuid) {
        this.shooterIdentity = uuid;
    }

    @Override
    @Nullable
    public UUID getShooterUUID() {
        return this.shooterIdentity;
    }

    @Override
    public void ping() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.pingback(this, this.getShooterUUID());
        }
    }

    @Override
    public boolean hasWarped() {
        return this.warped;
    }

    @Override
    public void setWarped(boolean warped) {
        this.warped = warped;
    }

    @Override
    public int getOrbitTime() {
        return this.orbitTime;
    }

    @Override
    public void setOrbitTime(int time) {
        this.orbitTime = time;
    }

    @Override
    public boolean hasTripped() {
        return this.tripped;
    }

    @Override
    public void setTripped(boolean tripped) {
        this.tripped = tripped;
    }

    @Override
    @Nullable
    public BlockPos getMagnetizedPos() {
        return this.magnetizePos;
    }

    @Override
    public void setMagnetizePos(@Nullable BlockPos pos) {
        this.magnetizePos = pos;
    }

    protected boolean shouldDoFakeParticles() {
        if (BotaniaConfig.client().staticWandBeam()) {
            return true;
        }
        ManaSpreader spreader = this.getShooter();
        return spreader != null && (this.getMana() != this.getStartingMana() && this.fullManaLastTick || Math.abs(spreader.getBurstParticleTick() - this.getTicksExisted()) < 4);
    }

    private void incrementFakeParticleTick() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
            if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
                spreader.setBurstParticleTick(0);
            }
        }
    }

    private void setDeathTicksForFakeParticle() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.setLastBurstDeathTick(this.getTicksExisted());
        }
    }

    public record PositionProperties(BlockPos coords, BlockState state) {
        public static PositionProperties fromEntity(Entity entity) {
            return new PositionProperties(entity.blockPosition(), entity.getBlockStateOn());
        }

        public boolean coordsEqual(PositionProperties props) {
            return this.coords.equals((Object)props.coords);
        }

        public boolean isInvalidIn(Level level) {
            return !level.hasChunkAt(this.coords);
        }

        public boolean contentsEqual(Level world) {
            if (this.isInvalidIn(world)) {
                return false;
            }
            return world.getBlockState(this.coords) == this.state;
        }
    }
}

