/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class MagicLandmineEntity
extends Entity {
    public GaiaGuardianEntity summoner;

    public MagicLandmineEntity(EntityType<MagicLandmineEntity> type, Level world) {
        super(type, world);
    }

    public void tick() {
        this.setDeltaMovement(Vec3.ZERO);
        super.tick();
        float range = this.getBbWidth() / 2.0f;
        float r = 0.2f;
        float g = 0.0f;
        float b = 0.2f;
        for (int i = 0; i < 6; ++i) {
            WispParticleData data = WispParticleData.wisp(0.4f, r, g, b, 1.0f);
            this.level().addParticle((ParticleOptions)data, this.getX() - (double)range + Math.random() * (double)range * 2.0, this.getY(), this.getZ() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
        }
        if (this.tickCount >= 55) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BotaniaSounds.gaiaTrap, SoundSource.NEUTRAL, 1.0f, 1.0f);
            float m = 0.35f;
            g = 0.4f;
            for (int i = 0; i < 25; ++i) {
                WispParticleData data = WispParticleData.wisp(0.5f, r, g, b);
                this.level().addParticle((ParticleOptions)data, this.getX(), this.getY() + 1.0, this.getZ(), (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * m));
            }
            if (!this.level().isClientSide) {
                List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox());
                for (Player player : players) {
                    player.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)this.summoner), 10.0f);
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 25, 0));
                    MobEffectInstance wither = new MobEffectInstance(MobEffects.WITHER, 120, 2);
                    player.addEffect(wither);
                }
            }
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag var1) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag var1) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }
}

