/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ThrowableCopyEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;

public class BabylonWeaponEntity
extends ThrowableCopyEntity {
    private static final String TAG_CHARGING = "charging";
    private static final String TAG_VARIETY = "variety";
    private static final String TAG_CHARGE_TICKS = "chargeTicks";
    private static final String TAG_LIVE_TICKS = "liveTicks";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_ROTATION = "rotation";
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIETY = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CHARGE_TICKS = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIVE_TICKS = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.defineId(BabylonWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public BabylonWeaponEntity(EntityType<BabylonWeaponEntity> type, Level world) {
        super(type, world);
    }

    public BabylonWeaponEntity(LivingEntity thrower, Level world) {
        super(BotaniaEntities.BABYLON_WEAPON, thrower, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CHARGING, (Object)false);
        builder.define(VARIETY, (Object)0);
        builder.define(CHARGE_TICKS, (Object)0);
        builder.define(LIVE_TICKS, (Object)0);
        builder.define(DELAY, (Object)0);
        builder.define(ROTATION, (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist < 4096.0;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    @Override
    public void tick() {
        boolean charging;
        Player player;
        Entity thrower;
        block18: {
            block17: {
                thrower = this.getOwner();
                if (!(thrower instanceof Player)) break block17;
                player = (Player)thrower;
                if (thrower.isAlive()) break block18;
            }
            if (!this.level().isClientSide) {
                this.discard();
            }
            return;
        }
        if (!this.level().isClientSide) {
            boolean newCharging;
            ItemStack stack = PlayerHelper.getFirstHeldItem((LivingEntity)player, BotaniaItems.kingKey);
            boolean bl = newCharging = !stack.isEmpty() && KeyOfTheKingsLawItem.isCharging(stack);
            if (this.isCharging() != newCharging) {
                this.setCharging(newCharging);
            }
        }
        Vec3 mot = this.getDeltaMovement();
        int liveTime = this.getLiveTicks();
        int delay = this.getDelay();
        boolean bl = charging = this.isCharging() && liveTime == 0;
        if (charging) {
            this.setDeltaMovement(Vec3.ZERO);
            int chargeTime = this.getChargeTicks();
            this.setChargeTicks(chargeTime + 1);
            if (this.level().random.nextInt(20) == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BotaniaSounds.babylonSpawn, SoundSource.PLAYERS, 0.1f, 1.0f + this.level().random.nextFloat() * 3.0f);
            }
        } else {
            if (liveTime < delay) {
                this.setDeltaMovement(Vec3.ZERO);
            } else if (liveTime == delay) {
                BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 64.0, true);
                Vec3 playerLook = rtr.getType() != HitResult.Type.BLOCK ? player.getLookAngle().scale(64.0).add(player.position()) : Vec3.atCenterOf((Vec3i)rtr.getBlockPos());
                Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
                mot = playerLook.subtract(thisVec.x, thisVec.y, thisVec.z).normalize().scale(2.0);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BotaniaSounds.babylonAttack, SoundSource.PLAYERS, 2.0f, 0.1f + this.level().random.nextFloat() * 3.0f);
            }
            if (!this.level().isClientSide) {
                this.setLiveTicks(liveTime + 1);
                AABB axis = new AABB(this.getX(), this.getY(), this.getZ(), this.xOld, this.yOld, this.zOld).inflate(2.0);
                List entities = this.level().getEntitiesOfClass(LivingEntity.class, axis);
                for (LivingEntity living : entities) {
                    if (living == thrower || living.hurtTime != 0) continue;
                    living.hurt(this.level().damageSources().playerAttack(player), 20.0f);
                    this.onHit((HitResult)new EntityHitResult((Entity)living));
                    return;
                }
            }
        }
        super.tick();
        this.setDeltaMovement(mot);
        if (this.level().isClientSide && liveTime > delay) {
            WispParticleData data = WispParticleData.wisp(0.3f, 1.0f, 1.0f, 0.0f, 1.0f);
            this.level().addParticle((ParticleOptions)data, this.getX(), this.getY(), this.getZ(), 0.0, -0.0, 0.0);
        }
        if (!this.level().isClientSide && liveTime > 200 + delay) {
            this.discard();
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult hit) {
        super.onHitBlock(hit);
        this.explodeAndDie();
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        super.onHitEntity(hit);
        if (hit.getEntity() != this.getOwner()) {
            this.explodeAndDie();
        }
    }

    private void explodeAndDie() {
        if (!this.level().isClientSide) {
            Holder.Reference type = this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(BotaniaDamageTypes.KEY_EXPLOSION);
            DamageSource source = new DamageSource((Holder)type, (Entity)this, this.getOwner());
            this.level().explode((Entity)this, source, null, this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putBoolean(TAG_CHARGING, this.isCharging());
        cmp.putInt(TAG_VARIETY, this.getVariety());
        cmp.putInt(TAG_CHARGE_TICKS, this.getChargeTicks());
        cmp.putInt(TAG_LIVE_TICKS, this.getLiveTicks());
        cmp.putInt(TAG_DELAY, this.getDelay());
        cmp.putFloat(TAG_ROTATION, this.getRotation());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.setCharging(cmp.getBoolean(TAG_CHARGING));
        this.setVariety(cmp.getInt(TAG_VARIETY));
        this.setChargeTicks(cmp.getInt(TAG_CHARGE_TICKS));
        this.setLiveTicks(cmp.getInt(TAG_LIVE_TICKS));
        this.setDelay(cmp.getInt(TAG_DELAY));
        this.setRotation(cmp.getFloat(TAG_ROTATION));
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(CHARGING, (Object)charging);
    }

    public int getVariety() {
        return (Integer)this.entityData.get(VARIETY);
    }

    public void setVariety(int var) {
        this.entityData.set(VARIETY, (Object)var);
    }

    public int getChargeTicks() {
        return (Integer)this.entityData.get(CHARGE_TICKS);
    }

    public void setChargeTicks(int ticks) {
        this.entityData.set(CHARGE_TICKS, (Object)ticks);
    }

    public int getLiveTicks() {
        return (Integer)this.entityData.get(LIVE_TICKS);
    }

    public void setLiveTicks(int ticks) {
        this.entityData.set(LIVE_TICKS, (Object)ticks);
    }

    public int getDelay() {
        return (Integer)this.entityData.get(DELAY);
    }

    public void setDelay(int delay) {
        this.entityData.set(DELAY, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.entityData.get(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.entityData.set(ROTATION, (Object)Float.valueOf(rot));
    }
}

