/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.WrappingRecipeSerializer;
import vazkii.botania.mixin.ShapedRecipeAccessor;
import vazkii.botania.mixin.ShapedRecipePatternAccessor;

public class WaterBottleMatchingRecipe
extends ShapedRecipe {
    public static final WrappingRecipeSerializer<WaterBottleMatchingRecipe> SERIALIZER = new Serializer();

    private static ShapedRecipePattern transformPattern(ShapedRecipePattern pattern) {
        ItemStack testPotion = new ItemStack((ItemLike)Items.POTION);
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])pattern.ingredients().stream().map(i -> i.test(testPotion) ? Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)}) : i).toArray(Ingredient[]::new)));
        return new ShapedRecipePattern(pattern.width(), pattern.height(), ingredients, ((ShapedRecipePatternAccessor)pattern).getData());
    }

    public WaterBottleMatchingRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result) {
        super(group, category, WaterBottleMatchingRecipe.transformPattern(pattern), result);
    }

    private WaterBottleMatchingRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), WaterBottleMatchingRecipe.transformPattern(((ShapedRecipeAccessor)recipe).botania_getPattern()), ((ShapedRecipeAccessor)recipe).botania_getResult(), recipe.showNotification());
    }

    public boolean matches(@NotNull CraftingInput craftingContainer, @NotNull Level level) {
        if (!super.matches(craftingContainer, level)) {
            return false;
        }
        for (int i = 0; i < craftingContainer.size(); ++i) {
            ItemStack item = craftingContainer.getItem(i);
            if (!item.is(Items.POTION) || ((PotionContents)item.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) continue;
            return false;
        }
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements WrappingRecipeSerializer<WaterBottleMatchingRecipe> {
        public static final MapCodec<WaterBottleMatchingRecipe> CODEC = SHAPED_RECIPE.codec().xmap(WaterBottleMatchingRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, WaterBottleMatchingRecipe> STREAM_CODEC = SHAPED_RECIPE.streamCodec().map(WaterBottleMatchingRecipe::new, Function.identity());

        private Serializer() {
        }

        @Override
        public WaterBottleMatchingRecipe wrap(Recipe<?> recipe) {
            if (!(recipe instanceof ShapedRecipe)) {
                throw new IllegalArgumentException("Unsupported recipe type to wrap: " + String.valueOf(recipe.getType()));
            }
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return new WaterBottleMatchingRecipe(shapedRecipe);
        }

        public MapCodec<WaterBottleMatchingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaterBottleMatchingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

