/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.crafting.recipe.WrappingRecipeSerializer;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.mixin.ShapedRecipeAccessor;

public class WandOfTheForestRecipe
extends ShapedRecipe {
    public static final WrappingRecipeSerializer<WandOfTheForestRecipe> SERIALIZER = new Serializer();

    private WandOfTheForestRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), ((ShapedRecipeAccessor)recipe).botania_getPattern(), ((ShapedRecipeAccessor)recipe).botania_getResult(), recipe.showNotification());
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        DyeColor first = null;
        for (int i = 0; i < inv.size(); ++i) {
            DyeColor colorId;
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof MysticalPetalItem) {
                MysticalPetalItem petal = (MysticalPetalItem)item;
                colorId = petal.color;
            } else {
                BlockItem block;
                Block block2;
                if (!(item instanceof BlockItem) || !((block2 = (block = (BlockItem)item).getBlock()) instanceof BotaniaMushroomBlock)) continue;
                BotaniaMushroomBlock mushroom = (BotaniaMushroomBlock)block2;
                colorId = mushroom.color;
            }
            if (first == null) {
                first = colorId;
                continue;
            }
            return WandOfTheForestItem.setColors(this.getResultItem(registries).copy(), first, colorId);
        }
        return WandOfTheForestItem.setColors(this.getResultItem(registries).copy(), first != null ? first : DyeColor.WHITE, DyeColor.WHITE);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements WrappingRecipeSerializer<WandOfTheForestRecipe> {
        public static final MapCodec<WandOfTheForestRecipe> CODEC = SHAPED_RECIPE.codec().xmap(WandOfTheForestRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, WandOfTheForestRecipe> STREAM_CODEC = SHAPED_RECIPE.streamCodec().map(WandOfTheForestRecipe::new, Function.identity());

        private Serializer() {
        }

        @Override
        public WandOfTheForestRecipe wrap(Recipe<?> recipe) {
            if (!(recipe instanceof ShapedRecipe)) {
                throw new IllegalArgumentException("Unsupported recipe type to wrap: " + String.valueOf(recipe.getType()));
            }
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return new WandOfTheForestRecipe(shapedRecipe);
        }

        public MapCodec<WandOfTheForestRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WandOfTheForestRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

