/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;

public class SplitLensRecipe
extends CustomRecipe {
    public static final RecipeSerializer<SplitLensRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(SplitLensRecipe::new);

    public SplitLensRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        return !this.assemble(inv, (HolderLookup.Provider)level.registryAccess()).isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack found = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack candidate = inv.getItem(i);
            if (candidate.isEmpty() || found.isEmpty() && !(found = this.getComposite(candidate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        if (!found.isEmpty()) {
            found = found.copyWithCount(1);
        }
        return found;
    }

    private ItemStack getComposite(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BasicLensItem)) {
            return ItemStack.EMPTY;
        }
        BasicLensItem basicLens = (BasicLensItem)item;
        return basicLens.getCompositeLens(stack);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack candidate = inv.getItem(i);
            Item item = candidate.getItem();
            if (!(item instanceof BasicLensItem)) continue;
            BasicLensItem basicLensItem = (BasicLensItem)item;
            ItemStack newLens = candidate.copyWithCount(1);
            basicLensItem.setCompositeLens(newLens, ItemStack.EMPTY);
            remaining.set(i, (Object)newLens);
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

