/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.BotaniaItems;

public class SpellbindingClothRecipe
extends CustomRecipe {
    public static final RecipeSerializer<SpellbindingClothRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(SpellbindingClothRecipe::new);

    public SpellbindingClothRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundCloth = false;
        boolean foundEnchanted = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.isEnchanted() && !foundEnchanted) {
                foundEnchanted = true;
                continue;
            }
            if (stack.is(BotaniaItems.spellCloth) && !foundCloth) {
                foundCloth = true;
                continue;
            }
            return false;
        }
        return foundCloth && foundEnchanted;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack stackToDisenchant = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.isEnchanted() || stack.is(BotaniaItems.spellCloth)) continue;
            stackToDisenchant = stack.copyWithCount(1);
            break;
        }
        if (stackToDisenchant.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return stackToDisenchant;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput inv) {
        return RecipeUtils.getRemainingItemsSub((RecipeInput)inv, s -> {
            if (s.is(BotaniaItems.spellCloth)) {
                ItemStack copy = s.copyWithCount(1);
                copy.setDamageValue(copy.getDamageValue() + 1);
                return copy;
            }
            return null;
        });
    }
}

