/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.ManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.WrappingRecipeSerializer;
import vazkii.botania.mixin.ShapelessRecipeAccessor;

public class ShapelessManaUpgradeRecipe
extends ShapelessRecipe {
    public static final WrappingRecipeSerializer<ShapelessManaUpgradeRecipe> SERIALIZER = new Serializer();

    private ShapelessManaUpgradeRecipe(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), ((ShapelessRecipeAccessor)recipe).botania_getResult(), recipe.getIngredients());
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        return ManaUpgradeRecipe.output(super.assemble(inv, registries), inv);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements WrappingRecipeSerializer<ShapelessManaUpgradeRecipe> {
        public static final MapCodec<ShapelessManaUpgradeRecipe> CODEC = SHAPELESS_RECIPE.codec().xmap(ShapelessManaUpgradeRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessManaUpgradeRecipe> STREAM_CODEC = SHAPELESS_RECIPE.streamCodec().map(ShapelessManaUpgradeRecipe::new, Function.identity());

        private Serializer() {
        }

        @Override
        public ShapelessManaUpgradeRecipe wrap(Recipe<?> recipe) {
            if (!(recipe instanceof ShapelessRecipe)) {
                throw new IllegalArgumentException("Unsupported recipe type to wrap: " + String.valueOf(recipe.getType()));
            }
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            return new ShapelessManaUpgradeRecipe(shapelessRecipe);
        }

        public MapCodec<ShapelessManaUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessManaUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

