/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.item.BotaniaItems;

public class ResoluteIvyRecipe
extends CustomRecipe {
    public static final RecipeSerializer<ResoluteIvyRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ResoluteIvyRecipe::new);

    public ResoluteIvyRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean foundIvy = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.keepIvy) && !foundIvy) {
                foundIvy = true;
                continue;
            }
            if (!(foundItem || stack.has(BotaniaDataComponents.RESOLUTE_IVY) || stack.getItem().hasCraftingRemainingItem())) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundIvy && foundItem;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack item = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.is(BotaniaItems.keepIvy)) continue;
            item = stack;
        }
        ItemStack copy = item.copyWithCount(1);
        copy.set(BotaniaDataComponents.RESOLUTE_IVY, (Object)Unit.INSTANCE);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

