/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.item.BotaniaItems;

public class PhantomInkRecipe
extends CustomRecipe {
    public static final RecipeSerializer<PhantomInkRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(PhantomInkRecipe::new);

    public PhantomInkRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput var1, @NotNull Level var2) {
        boolean foundInk = false;
        boolean foundItem = false;
        for (int i = 0; i < var1.size(); ++i) {
            ItemStack stack = var1.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.phantomInk) && !foundInk) {
                foundInk = true;
                continue;
            }
            if (!foundItem) {
                if (stack.getItem() instanceof PhantomInkable && !stack.getItem().hasCraftingRemainingItem()) {
                    foundItem = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundInk && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack item = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof PhantomInkable) || !item.isEmpty()) continue;
            item = stack;
        }
        PhantomInkable inkable = (PhantomInkable)item.getItem();
        ItemStack copy = item.copy();
        inkable.setPhantomInk(copy, !inkable.hasPhantomInk(item));
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

