/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class NbtOutputRecipe<C extends RecipeInput>
implements Recipe<C> {
    public static final RecipeSerializer<NbtOutputRecipe<?>> SERIALIZER = new Serializer();
    private final Recipe<C> recipe;

    public NbtOutputRecipe(Recipe<C> recipe) {
        this.recipe = recipe;
    }

    public boolean matches(C container, Level level) {
        return this.recipe.matches(container, level);
    }

    public ItemStack assemble(C container, HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.recipe.canCraftInDimensions(width, height);
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.recipe.getResultItem(registryAccess);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return this.recipe.getType();
    }

    private static class Serializer
    implements RecipeSerializer<NbtOutputRecipe<?>> {
        public static final MapCodec<NbtOutputRecipe<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Recipe.CODEC.fieldOf("recipe").forGetter(r -> r.recipe)).apply((Applicative)instance, NbtOutputRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, NbtOutputRecipe<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)Recipe.STREAM_CODEC, r -> r.recipe, NbtOutputRecipe::new);

        private Serializer() {
        }

        public MapCodec<NbtOutputRecipe<?>> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NbtOutputRecipe<?>> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

