/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.item.brew.BaseBrewItem;

public class MergeVialRecipe
extends CustomRecipe {
    public static final RecipeSerializer<MergeVialRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(MergeVialRecipe::new);

    public MergeVialRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, @NotNull Level worldIn) {
        int count = 0;
        Brew brew = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (!(item instanceof BaseBrewItem)) {
                return false;
            }
            BaseBrewItem vial = (BaseBrewItem)item;
            if (brew == null) {
                brew = vial.getBrew(stack);
            } else if (brew != vial.getBrew(stack)) {
                return false;
            }
            ++count;
        }
        return count > 1;
    }

    @NotNull
    public ItemStack assemble(CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack firstStack = ItemStack.EMPTY;
        BaseBrewItem brew = null;
        int swigs = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (brew == null) {
                firstStack = stack.copy();
                brew = (BaseBrewItem)stack.getItem();
            }
            if ((swigs += brew.getSwigsLeft(stack)) < brew.getSwigs(stack)) continue;
            swigs = brew.getSwigs(stack);
            break;
        }
        ((BaseBrewItem)Objects.requireNonNull(brew)).setSwigsLeft(firstStack, swigs);
        return firstStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        boolean foundFirst = false;
        int swigs = 0;
        int maxSwigs = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            BaseBrewItem brew = (BaseBrewItem)stack.getItem();
            if (!foundFirst) {
                foundFirst = true;
                swigs = brew.getSwigsLeft(stack);
                maxSwigs = brew.getSwigs(stack);
                continue;
            }
            if ((swigs += brew.getSwigsLeft(stack)) > maxSwigs) {
                brew.setSwigsLeft(stack, swigs - maxSwigs);
                swigs = maxSwigs;
                remaining.set(i, (Object)stack.copy());
                continue;
            }
            remaining.set(i, (Object)brew.getBaseStack());
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

