/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.crafting.recipe.WrappingRecipeSerializer;
import vazkii.botania.mixin.ShapedRecipeAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaUpgradeRecipe
extends ShapedRecipe {
    public static final WrappingRecipeSerializer<ManaUpgradeRecipe> SERIALIZER = new Serializer();

    private ManaUpgradeRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), ((ShapedRecipeAccessor)recipe).botania_getPattern(), ((ShapedRecipeAccessor)recipe).botania_getResult(), recipe.showNotification());
    }

    public static ItemStack output(ItemStack output, CraftingInput inv) {
        ItemStack out = output.copy();
        ManaItem outItem = XplatAbstractions.INSTANCE.findManaItem(out);
        if (outItem == null) {
            return out;
        }
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            ManaItem item = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.isEmpty() || item == null) continue;
            outItem.addMana(item.getMana());
        }
        return out;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        return ManaUpgradeRecipe.output(super.assemble(inv, registries), inv);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements WrappingRecipeSerializer<ManaUpgradeRecipe> {
        public static final MapCodec<ManaUpgradeRecipe> CODEC = SHAPED_RECIPE.codec().xmap(ManaUpgradeRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, ManaUpgradeRecipe> STREAM_CODEC = SHAPED_RECIPE.streamCodec().map(ManaUpgradeRecipe::new, Function.identity());

        private Serializer() {
        }

        @Override
        public ManaUpgradeRecipe wrap(Recipe<?> recipe) {
            if (!(recipe instanceof ShapedRecipe)) {
                throw new IllegalArgumentException("Unsupported recipe type to wrap: " + String.valueOf(recipe.getType()));
            }
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return new ManaUpgradeRecipe(shapedRecipe);
        }

        public MapCodec<ManaUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ManaUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

