/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterClipRecipe
extends CustomRecipe {
    public static final RecipeSerializer<ManaBlasterClipRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ManaBlasterClipRecipe::new);

    public ManaBlasterClipRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundGun = false;
        boolean foundClip = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ManaBlasterItem && !ManaBlasterItem.hasClip(stack) && !foundGun) {
                foundGun = true;
                continue;
            }
            if (stack.is(BotaniaItems.clip) && !foundClip) {
                foundClip = true;
                continue;
            }
            return false;
        }
        return foundGun && foundClip;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack gun = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof ManaBlasterItem)) continue;
            gun = stack;
        }
        if (gun.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack lens = ManaBlasterItem.getLens(gun);
        ItemStack gunCopy = gun.copy();
        ManaBlasterItem.setLens(gunCopy, ItemStack.EMPTY);
        ManaBlasterItem.setClip(gunCopy, true);
        ManaBlasterItem.setLensAtPos(gunCopy, lens, 0);
        return gunCopy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

