/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

public class LensDyeingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<LensDyeingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(LensDyeingRecipe::new);
    private final Supplier<List<Ingredient>> dyes = Suppliers.memoize(() -> Arrays.asList(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGENTA_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_BLUE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.YELLOW_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIME_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAY_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_GRAY_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CYAN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GREEN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));

    public LensDyeingRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean foundLens = false;
        boolean foundDye = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BasicLensItem && !foundLens) {
                foundLens = true;
                continue;
            }
            if (!foundDye) {
                if (stack.getItem() instanceof DyeItem || stack.is(BotaniaItems.manaPearl)) {
                    foundDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundDye;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack lens = ItemStack.EMPTY;
        DyeColor color = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BasicLensItem && lens.isEmpty()) {
                lens = stack;
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            color = dyeItem.getDyeColor();
        }
        if (lens.getItem() instanceof BasicLensItem) {
            ItemStack lensCopy = lens.copyWithCount(1);
            if (color != null) {
                LensItem.setLensColor(lensCopy, color);
            } else {
                LensItem.setLensRainbow(lensCopy);
            }
            return lensCopy;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

