/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LaputaShardItem;

public class LaputaShardUpgradeRecipe
extends CustomRecipe {
    public static final RecipeSerializer<LaputaShardUpgradeRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(LaputaShardUpgradeRecipe::new);

    public LaputaShardUpgradeRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        boolean foundShard = false;
        boolean foundSpirit = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.laputaShard) && !foundShard && LaputaShardItem.getShardLevel(stack) < 19) {
                foundShard = true;
                continue;
            }
            if (stack.is(BotaniaItems.lifeEssence) && !foundSpirit) {
                foundSpirit = true;
                continue;
            }
            return false;
        }
        return foundShard && foundSpirit;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)BotaniaItems.laputaShard);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.laputaShard}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.lifeEssence})});
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!stack.is(BotaniaItems.laputaShard)) continue;
            ItemStack result = stack.copy();
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

