/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.RunicAltarRecipe;

public class HeadRecipe
extends RunicAltarRecipe {
    public HeadRecipe(ItemStack output, Ingredient reagent, int mana, Ingredient ... inputs) {
        super(output, reagent, mana, inputs, new Ingredient[0]);
    }

    private HeadRecipe(RunicAltarRecipe recipe) {
        super(recipe.getOutput(), recipe.getReagent(), recipe.getMana(), (Ingredient[])recipe.getIngredients().toArray(Ingredient[]::new), (Ingredient[])recipe.getCatalysts().toArray(Ingredient[]::new));
    }

    @Override
    public boolean matches(RecipeInput inv, Level world) {
        boolean matches = super.matches(inv, world);
        if (matches) {
            ItemStack stack;
            for (int i = 0; i < inv.size() && !(stack = inv.getItem(i)).isEmpty(); ++i) {
                if (!stack.is(Items.NAME_TAG)) continue;
                String defaultName = Component.translatable((String)Items.NAME_TAG.getDescriptionId()).getString();
                if (!stack.getHoverName().getString().equals(defaultName)) continue;
                return false;
            }
        }
        return matches;
    }

    @Override
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider registries) {
        ItemStack stack = this.getResultItem(registries).copy();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack ingr = inv.getItem(i);
            if (!ingr.is(Items.NAME_TAG)) continue;
            stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(ingr.getHoverName().getString()), Optional.empty(), new PropertyMap()));
            break;
        }
        return stack;
    }

    public static class Serializer
    implements RecipeSerializer<HeadRecipe> {
        public static final MapCodec<HeadRecipe> CODEC = RunicAltarRecipe.Serializer.CODEC.xmap(HeadRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, HeadRecipe> STREAM_CODEC = RunicAltarRecipe.Serializer.STREAM_CODEC.map(HeadRecipe::new, Function.identity());

        public MapCodec<HeadRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HeadRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

