/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.botania.xplat.XplatAbstractions;

public class GogAlternationRecipe<C extends RecipeInput>
implements Recipe<C> {
    public static final RecipeSerializer<GogAlternationRecipe<?>> SERIALIZER = new Serializer();
    private final Supplier<Boolean> isGog = Suppliers.memoize(XplatAbstractions.INSTANCE::gogLoaded);
    private final Recipe<?> baseRecipe;
    private final Recipe<?> gogRecipe;

    public GogAlternationRecipe(Recipe<?> baseRecipe, Recipe<?> gogRecipe) {
        this.baseRecipe = baseRecipe;
        this.gogRecipe = gogRecipe;
    }

    public Recipe<?> getBaseRecipe() {
        return this.baseRecipe;
    }

    public Recipe<?> getGogRecipe() {
        return this.gogRecipe;
    }

    public Recipe<C> getRecipe() {
        return this.isGog.get() != false ? this.gogRecipe : this.baseRecipe;
    }

    public boolean matches(C container, Level level) {
        return this.getRecipe().matches(container, level);
    }

    public ItemStack assemble(C container, HolderLookup.Provider registryAccess) {
        return this.getRecipe().assemble(container, registryAccess);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.getRecipe().canCraftInDimensions(width, height);
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getRecipe().getResultItem(registryAccess);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return this.getRecipe().getType();
    }

    private static class Serializer
    implements RecipeSerializer<GogAlternationRecipe<?>> {
        private static final MapCodec<GogAlternationRecipe<?>> RAW_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Recipe.CODEC.fieldOf("base").forGetter(GogAlternationRecipe::getBaseRecipe), (App)Recipe.CODEC.fieldOf("gog").forGetter(GogAlternationRecipe::getGogRecipe)).apply((Applicative)instance, GogAlternationRecipe::new));
        public static final MapCodec<GogAlternationRecipe<?>> CODEC = RAW_CODEC.validate(recipe -> {
            if (recipe.getBaseRecipe().getType() != recipe.getGogRecipe().getType()) {
                return DataResult.error(() -> "Subrecipes must have matching types");
            }
            return DataResult.success((Object)recipe);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, GogAlternationRecipe<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)Recipe.STREAM_CODEC, GogAlternationRecipe::getBaseRecipe, (StreamCodec)Recipe.STREAM_CODEC, GogAlternationRecipe::getGogRecipe, GogAlternationRecipe::new);

        private Serializer() {
        }

        public MapCodec<GogAlternationRecipe<?>> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GogAlternationRecipe<?>> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

