/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class CosmeticRemoveRecipe
extends CustomRecipe {
    public static final RecipeSerializer<CosmeticRemoveRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(CosmeticRemoveRecipe::new);

    public CosmeticRemoveRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundAttachable = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.getItem() instanceof CosmeticBauble) && !attachable.getCosmeticItem(stack).isEmpty()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack attachableItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            attachableItem = stack;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)attachableItem.getItem();
        if (attachable.getCosmeticItem(attachableItem).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = attachableItem.copyWithCount(1);
        attachable.setCosmeticItem(copy, ItemStack.EMPTY);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput inv) {
        return RecipeUtils.getRemainingItemsSub((RecipeInput)inv, s -> {
            Item patt0$temp = s.getItem();
            if (patt0$temp instanceof BaubleItem) {
                BaubleItem bauble = (BaubleItem)patt0$temp;
                ItemStack stack = bauble.getCosmeticItem((ItemStack)s);
                stack.setCount(1);
                return stack;
            }
            return null;
        });
    }
}

