/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;

public class CosmeticAttachRecipe
extends CustomRecipe {
    public static final RecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(CosmeticAttachRecipe::new);

    public CosmeticAttachRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundCosmetic = false;
        boolean foundAttachable = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CosmeticBauble && !foundCosmetic) {
                foundCosmetic = true;
                continue;
            }
            if (foundAttachable) continue;
            Item item = stack.getItem();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.getItem() instanceof CosmeticBauble) && attachable.getCosmeticItem(stack).isEmpty()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundCosmetic && foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        Item stack;
        ItemStack cosmeticItem = ItemStack.EMPTY;
        ItemStack attachableItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CosmeticBauble && cosmeticItem.isEmpty()) {
                cosmeticItem = stack;
                continue;
            }
            attachableItem = stack;
        }
        stack = attachableItem.getItem();
        if (!(stack instanceof CosmeticAttachable)) {
            return ItemStack.EMPTY;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)stack;
        if (!attachable.getCosmeticItem(attachableItem).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = attachableItem.copy();
        attachable.setCosmeticItem(copy, cosmeticItem);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

