/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;

public class BlackHoleTalismanExtractRecipe
extends CustomRecipe {
    public static final RecipeSerializer<BlackHoleTalismanExtractRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(BlackHoleTalismanExtractRecipe::new);

    public BlackHoleTalismanExtractRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean foundTalisman = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.blackHoleTalisman) && !foundTalisman) {
                int count = BlackHoleTalismanItem.getBlockCount(stack);
                if (count <= 0) {
                    return false;
                }
                foundTalisman = true;
                continue;
            }
            return false;
        }
        return foundTalisman;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        Block block;
        ItemStack talisman = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            talisman = stack;
        }
        int count = BlackHoleTalismanItem.getBlockCount(talisman);
        if (count > 0 && (block = BlackHoleTalismanItem.getBlock(talisman)) != null) {
            return new ItemStack((ItemLike)block, Math.min(64, count));
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        return RecipeUtils.getRemainingItemsSub((RecipeInput)inv, s -> {
            if (s.is(BotaniaItems.blackHoleTalisman)) {
                int count = BlackHoleTalismanItem.getBlockCount(s);
                if (count == 0) {
                    return ItemStack.EMPTY;
                }
                int extract = Math.min(64, count);
                ItemStack copy = s.copyWithCount(1);
                BlackHoleTalismanItem.remove(copy, extract);
                copy.remove(BotaniaDataComponents.ACTIVE);
                return copy;
            }
            return null;
        });
    }
}

