/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.common.item.AncientWillItem;

public class AncientWillRecipe
extends CustomRecipe {
    public static final RecipeSerializer<AncientWillRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(AncientWillRecipe::new);

    public AncientWillRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundWill = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof AncientWillItem && !foundWill) {
                foundWill = true;
                continue;
            }
            if (foundItem) continue;
            if (stack.getItem() instanceof AncientWillContainer) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundWill && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack item = ItemStack.EMPTY;
        AncientWillContainer.AncientWillType will = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof AncientWillContainer && item.isEmpty()) {
                item = stack;
                continue;
            }
            will = ((AncientWillItem)stack.getItem()).type;
        }
        AncientWillContainer container = (AncientWillContainer)item.getItem();
        if (container.hasAncientWill(item, will)) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = item.copy();
        container.addAncientWill(copy, will);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width > 1 || height > 1;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

