/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class TerrestrialAgglomerationRecipe
implements vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe {
    private final int mana;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;

    public TerrestrialAgglomerationRecipe(int mana, ItemStack output, Ingredient ... ingredients) {
        this.mana = mana;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients);
        this.output = output;
    }

    private static TerrestrialAgglomerationRecipe of(List<Ingredient> ingredients, int mana, ItemStack output) {
        return new TerrestrialAgglomerationRecipe(mana, output, (Ingredient[])ingredients.toArray(Ingredient[]::new));
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean matches(RecipeInput inv, @NotNull Level world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inv.size(); ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            if (inv.getItem(i).getCount() > 1) {
                return false;
            }
            ++nonEmptySlots;
        }
        IntOpenHashSet usedSlots = new IntOpenHashSet(inv.size());
        return RecipeUtils.matches(this.ingredients, inv, (IntSet)usedSlots) && usedSlots.size() == nonEmptySlots;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider registries) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public RecipeSerializer<? extends TerrestrialAgglomerationRecipe> getSerializer() {
        return BotaniaRecipeTypes.TERRA_PLATE_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<TerrestrialAgglomerationRecipe> {
        public static final MapCodec<TerrestrialAgglomerationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)Ingredient.CODEC_NONEMPTY.listOf()).fieldOf("ingredients").forGetter(TerrestrialAgglomerationRecipe::getIngredients), (App)ExtraCodecs.POSITIVE_INT.fieldOf("mana").forGetter(TerrestrialAgglomerationRecipe::getMana), (App)ItemStack.CODEC.fieldOf("result").forGetter(TerrestrialAgglomerationRecipe::getOutput)).apply((Applicative)instance, TerrestrialAgglomerationRecipe::of));
        public static final StreamCodec<RegistryFriendlyByteBuf, TerrestrialAgglomerationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), TerrestrialAgglomerationRecipe::getIngredients, (StreamCodec)ByteBufCodecs.VAR_INT, TerrestrialAgglomerationRecipe::getMana, (StreamCodec)ItemStack.STREAM_CODEC, TerrestrialAgglomerationRecipe::getOutput, TerrestrialAgglomerationRecipe::of);

        public MapCodec<TerrestrialAgglomerationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TerrestrialAgglomerationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

