/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RunicAltarRecipe
implements vazkii.botania.api.recipe.RunicAltarRecipe {
    private final ItemStack output;
    private final Ingredient reagent;
    private final NonNullList<Ingredient> ingredients;
    private final NonNullList<Ingredient> catalysts;
    private final NonNullList<Ingredient> allInputs;
    private final int mana;

    public RunicAltarRecipe(ItemStack output, Ingredient reagent, int mana, Ingredient[] ingredients, Ingredient[] catalysts) {
        int i;
        int numIngredients = ingredients.length;
        int numCatalysts = catalysts.length;
        Preconditions.checkArgument((numIngredients <= 16 ? 1 : 0) != 0, (Object)"Cannot have more than 16 ingredients");
        this.output = output;
        this.reagent = reagent;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients);
        this.catalysts = NonNullList.of((Object)Ingredient.EMPTY, (Object[])catalysts);
        this.mana = mana;
        this.allInputs = NonNullList.withSize((int)(numIngredients + numCatalysts), (Object)Ingredient.EMPTY);
        for (i = 0; i < numIngredients; ++i) {
            this.allInputs.set(i, (Object)ingredients[i]);
        }
        for (i = 0; i < numCatalysts; ++i) {
            this.allInputs.set(i + numIngredients, (Object)catalysts[i]);
        }
    }

    private static RunicAltarRecipe of(List<Ingredient> ingredients, List<Ingredient> catalysts, Ingredient reagent, int mana, ItemStack output) {
        return new RunicAltarRecipe(output, reagent, mana, (Ingredient[])ingredients.toArray(Ingredient[]::new), (Ingredient[])catalysts.toArray(Ingredient[]::new));
    }

    public boolean matches(RecipeInput container, @NotNull Level world) {
        return RecipeUtils.matches(this.allInputs, container, null);
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(RecipeInput container) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredients);
        ArrayList<Ingredient> catalystsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.catalysts);
        NonNullList foundCatalysts = NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
        block0: for (int i = 0; i < container.size() && !(input = container.getItem(i)).isEmpty(); ++i) {
            Ingredient ingr;
            int j;
            for (j = 0; j < ingredientsMissing.size(); ++j) {
                ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                ingredientsMissing.remove(j);
                continue block0;
            }
            for (j = 0; j < catalystsMissing.size(); ++j) {
                ingr = (Ingredient)catalystsMissing.get(j);
                if (!ingr.test(input)) continue;
                catalystsMissing.remove(j);
                foundCatalysts.add((Object)input);
                continue block0;
            }
        }
        return foundCatalysts;
    }

    @NotNull
    public final ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getCatalysts() {
        return this.catalysts;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.runeAltar);
    }

    @NotNull
    public RecipeSerializer<? extends RunicAltarRecipe> getSerializer() {
        return BotaniaRecipeTypes.RUNE_SERIALIZER;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public Ingredient getReagent() {
        return this.reagent;
    }

    public static class Serializer
    implements RecipeSerializer<RunicAltarRecipe> {
        private static final MapCodec<RunicAltarRecipe> RAW_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)Ingredient.CODEC_NONEMPTY.listOf()).fieldOf("ingredients").forGetter(RunicAltarRecipe::getIngredients), (App)ExtraCodecs.nonEmptyList((Codec)Ingredient.CODEC_NONEMPTY.listOf()).fieldOf("catalysts").forGetter(RunicAltarRecipe::getCatalysts), (App)Ingredient.CODEC_NONEMPTY.fieldOf("reagent").forGetter(RunicAltarRecipe::getReagent), (App)ExtraCodecs.POSITIVE_INT.fieldOf("mana").forGetter(RunicAltarRecipe::getMana), (App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("output").forGetter(RunicAltarRecipe::getOutput)).apply((Applicative)instance, RunicAltarRecipe::of));
        public static final MapCodec<RunicAltarRecipe> CODEC = RAW_CODEC.validate(recipe -> {
            if (recipe.getIngredients().size() + recipe.getCatalysts().size() > 16) {
                return DataResult.error(() -> "Cannot have more than 16 ingredients and catalysts in total");
            }
            return DataResult.success((Object)recipe);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, RunicAltarRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RunicAltarRecipe::getIngredients, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RunicAltarRecipe::getCatalysts, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RunicAltarRecipe::getReagent, (StreamCodec)ByteBufCodecs.VAR_INT, RunicAltarRecipe::getMana, (StreamCodec)ItemStack.STREAM_CODEC, RunicAltarRecipe::getOutput, RunicAltarRecipe::of);

        public MapCodec<RunicAltarRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RunicAltarRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

