/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredients;

public class PureDaisyRecipe
implements vazkii.botania.api.recipe.PureDaisyRecipe {
    public static final int DEFAULT_TIME = 150;
    private final StateIngredient input;
    private final StateIngredient output;
    private final int time;
    private final boolean copyInputProperties;
    private final CacheableFunction successFunction;

    public PureDaisyRecipe(StateIngredient input, StateIngredient output, int time, boolean copyInputProperties, @Nullable CacheableFunction successFunction) {
        this.input = input;
        this.output = output;
        this.time = time;
        this.successFunction = successFunction;
        this.copyInputProperties = copyInputProperties;
    }

    private static PureDaisyRecipe of(StateIngredient input, StateIngredient output, int time, boolean copyInputProperties, Optional<CacheableFunction> successFunction) {
        return new PureDaisyRecipe(input, output, time, copyInputProperties, successFunction.orElse(null));
    }

    @Override
    public boolean matches(Level world, BlockPos pos, BlockState state) {
        return this.input.test(state);
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public StateIngredient getOutput() {
        return this.output;
    }

    @Override
    public boolean isCopyInputProperties() {
        return this.copyInputProperties;
    }

    @Override
    public Optional<CacheableFunction> getSuccessFunction() {
        return Optional.ofNullable(this.successFunction);
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public RecipeSerializer<? extends PureDaisyRecipe> getSerializer() {
        return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PureDaisyRecipe> {
        public static final MapCodec<PureDaisyRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StateIngredients.TYPED_CODEC.fieldOf("input").forGetter(PureDaisyRecipe::getInput), (App)StateIngredients.TYPED_CODEC.fieldOf("output").forGetter(PureDaisyRecipe::getOutput), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("time", (Object)0).forGetter(PureDaisyRecipe::getTime), (App)Codec.BOOL.optionalFieldOf("copy_properties", (Object)false).forGetter(PureDaisyRecipe::isCopyInputProperties), (App)CacheableFunction.CODEC.optionalFieldOf("success_function").forGetter(PureDaisyRecipe::getSuccessFunction)).apply((Applicative)instance, PureDaisyRecipe::of));
        public static final StreamCodec<RegistryFriendlyByteBuf, PureDaisyRecipe> STREAM_CODEC = StreamCodec.composite(StateIngredients.TYPED_STREAM_CODEC, PureDaisyRecipe::getInput, StateIngredients.TYPED_STREAM_CODEC, PureDaisyRecipe::getOutput, (StreamCodec)ByteBufCodecs.VAR_INT, PureDaisyRecipe::getTime, (StreamCodec)ByteBufCodecs.BOOL, PureDaisyRecipe::isCopyInputProperties, (input, output, time, copyInputProperties) -> new PureDaisyRecipe((StateIngredient)input, (StateIngredient)output, (int)time, (boolean)copyInputProperties, null));

        public MapCodec<PureDaisyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PureDaisyRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

