/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class PetalApothecaryRecipe
implements vazkii.botania.api.recipe.PetalApothecaryRecipe {
    private final ItemStack output;
    private final Ingredient reagent;
    private final NonNullList<Ingredient> ingredients;

    public PetalApothecaryRecipe(ItemStack output, Ingredient reagent, Ingredient ... ingredients) {
        this.output = output;
        this.reagent = reagent;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients);
    }

    private static PetalApothecaryRecipe of(ItemStack output, Ingredient reagent, List<Ingredient> ingredients) {
        return new PetalApothecaryRecipe(output, reagent, (Ingredient[])ingredients.toArray(Ingredient[]::new));
    }

    public boolean matches(RecipeInput inv, @NotNull Level world) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredients);
        for (int i = 0; i < inv.size() && !(input = inv.getItem(i)).isEmpty(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @NotNull
    public final ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public Ingredient getReagent() {
        return this.reagent;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.defaultAltar);
    }

    @NotNull
    public RecipeSerializer<? extends PetalApothecaryRecipe> getSerializer() {
        return BotaniaRecipeTypes.PETAL_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PetalApothecaryRecipe> {
        public final MapCodec<PetalApothecaryRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(PetalApothecaryRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.fieldOf("reagent").forGetter(PetalApothecaryRecipe::getReagent), (App)Ingredient.CODEC_NONEMPTY.listOf(1, 16).fieldOf("ingredients").forGetter(PetalApothecaryRecipe::getIngredients)).apply((Applicative)instance, PetalApothecaryRecipe::of));
        public static final StreamCodec<RegistryFriendlyByteBuf, PetalApothecaryRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, PetalApothecaryRecipe::getOutput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PetalApothecaryRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), PetalApothecaryRecipe::getIngredients, PetalApothecaryRecipe::of);

        public MapCodec<PetalApothecaryRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PetalApothecaryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

