/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredients;

public class ManaInfusionRecipe
implements vazkii.botania.api.recipe.ManaInfusionRecipe {
    private final ItemStack output;
    private final Ingredient input;
    private final int mana;
    private final StateIngredient catalyst;
    private final String group;

    public ManaInfusionRecipe(ItemStack output, Ingredient input, int mana, String group, StateIngredient catalyst) {
        this.output = output;
        this.input = input;
        this.mana = mana;
        this.group = group == null ? "" : group;
        this.catalyst = catalyst == null ? StateIngredients.NONE : catalyst;
    }

    @NotNull
    public RecipeSerializer<ManaInfusionRecipe> getSerializer() {
        return BotaniaRecipeTypes.MANA_INFUSION_SERIALIZER;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    @NotNull
    public StateIngredient getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getManaToConsume() {
        return this.mana;
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.manaPool);
    }

    protected Ingredient getInput() {
        return this.input;
    }

    protected ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer
    implements RecipeSerializer<ManaInfusionRecipe> {
        public static final MapCodec<ManaInfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(ManaInfusionRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(ManaInfusionRecipe::getInput), (App)ExtraCodecs.intRange((int)1, (int)1000001).fieldOf("mana").forGetter(ManaInfusionRecipe::getManaToConsume), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ManaInfusionRecipe::getGroup), (App)StateIngredients.TYPED_CODEC.optionalFieldOf("catalyst", (Object)StateIngredients.NONE).forGetter(ManaInfusionRecipe::getRecipeCatalyst)).apply((Applicative)instance, ManaInfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ManaInfusionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ManaInfusionRecipe::getOutput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ManaInfusionRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_INT, ManaInfusionRecipe::getManaToConsume, (StreamCodec)ByteBufCodecs.STRING_UTF8, ManaInfusionRecipe::getGroup, StateIngredients.TYPED_STREAM_CODEC, ManaInfusionRecipe::getRecipeCatalyst, ManaInfusionRecipe::new);

        public MapCodec<ManaInfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ManaInfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

