/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;

public class LexiconElvenTradeRecipe
implements ElvenTradeRecipe {
    @Override
    public boolean containsItem(ItemStack stack) {
        return false;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.lexicon}));
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.alfPortal);
    }

    @Override
    public List<ItemStack> getOutputs() {
        ItemStack stack = new ItemStack((ItemLike)BotaniaItems.lexicon);
        return Collections.singletonList(stack);
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!this.containsItem(stack)) continue;
            return Optional.of(Collections.singletonList(stack));
        }
        return Optional.empty();
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        ItemStack stack = inputs.get(0).copy();
        return Collections.singletonList(stack);
    }

    @NotNull
    public RecipeSerializer<LexiconElvenTradeRecipe> getSerializer() {
        return BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<LexiconElvenTradeRecipe> {
        public MapCodec<LexiconElvenTradeRecipe> codec() {
            return MapCodec.unit(LexiconElvenTradeRecipe::new);
        }

        public StreamCodec<RegistryFriendlyByteBuf, LexiconElvenTradeRecipe> streamCodec() {
            return StreamCodec.unit((Object)new LexiconElvenTradeRecipe());
        }
    }
}

