/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class ElvenTradeRecipe
implements vazkii.botania.api.recipe.ElvenTradeRecipe {
    private final ImmutableList<ItemStack> outputs;
    private final NonNullList<Ingredient> inputs;

    public ElvenTradeRecipe(ItemStack[] outputs, Ingredient ... inputs) {
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs);
    }

    public ElvenTradeRecipe(List<ItemStack> outputs, List<Ingredient> ingredients) {
        this.outputs = ImmutableList.copyOf(outputs);
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                Ingredient ingr = (Ingredient)inputsMissing.get(i);
                if (!ingr.test(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        for (Ingredient input : this.inputs) {
            if (!input.test(stack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.alfPortal);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        return this.getOutputs();
    }

    public static class Serializer
    implements RecipeSerializer<ElvenTradeRecipe> {
        public static final MapCodec<ElvenTradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)ItemStack.SIMPLE_ITEM_CODEC.listOf()).fieldOf("output").forGetter(ElvenTradeRecipe::getOutputs), (App)ExtraCodecs.nonEmptyList((Codec)Ingredient.CODEC_NONEMPTY.listOf()).fieldOf("ingredients").forGetter(ElvenTradeRecipe::getIngredients)).apply((Applicative)instance, ElvenTradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ElvenTradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, ElvenTradeRecipe::getOutputs, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), ElvenTradeRecipe::getIngredients, ElvenTradeRecipe::new);

        public MapCodec<ElvenTradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ElvenTradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

