/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BotanicalBreweryRecipe
implements vazkii.botania.api.recipe.BotanicalBreweryRecipe {
    private final Brew brew;
    private final NonNullList<Ingredient> inputs;

    public BotanicalBreweryRecipe(Brew brew, Ingredient ... inputs) {
        this.brew = brew;
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs);
    }

    public BotanicalBreweryRecipe(Brew brew, List<Ingredient> ingredients) {
        this(brew, (Ingredient[])ingredients.toArray(Ingredient[]::new));
    }

    public boolean matches(RecipeInput inv, @NotNull Level world) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.size() && !(stack = inv.getItem(i)).isEmpty(); ++i) {
            if (stack.getItem() instanceof BrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.brewery);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        Item item;
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof BrewContainer)) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        BrewContainer container = (BrewContainer)item;
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof BotanicalBreweryRecipe)) return false;
        BotanicalBreweryRecipe brewRecipe = (BotanicalBreweryRecipe)o;
        if (this.brew != brewRecipe.brew) return false;
        if (!this.inputs.equals(brewRecipe.inputs)) return false;
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BotanicalBreweryRecipe> {
        public static final MapCodec<BotanicalBreweryRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BotaniaAPI.instance().getBrewRegistry().byNameCodec().fieldOf("brew").forGetter(BotanicalBreweryRecipe::getBrew), (App)ExtraCodecs.nonEmptyList((Codec)Ingredient.CODEC_NONEMPTY.listOf()).fieldOf("ingredients").forGetter(BotanicalBreweryRecipe::getIngredients)).apply((Applicative)instance, BotanicalBreweryRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BotanicalBreweryRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(BotaniaRegistries.BREWS), BotanicalBreweryRecipe::getBrew, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), BotanicalBreweryRecipe::getIngredients, BotanicalBreweryRecipe::new);

        public MapCodec<BotanicalBreweryRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BotanicalBreweryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

