/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.recipe.StateIngredientType;
import vazkii.botania.common.crafting.StateIngredients;

public record BlockTypeIngredient(Block block) implements StateIngredient
{
    @Override
    public boolean test(BlockState blockState) {
        return blockState.is(this.block);
    }

    @Override
    public BlockState pick(RandomSource random) {
        return this.block.defaultBlockState();
    }

    public StateIngredientType<BlockTypeIngredient> getType() {
        return StateIngredients.BLOCK_TYPE;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.block == Blocks.AIR ? Collections.emptyList() : Collections.singletonList(new ItemStack((ItemLike)this.block.asItem()));
    }

    @Override
    public List<BlockState> getDisplayed() {
        return Collections.singletonList(this.block.defaultBlockState());
    }

    @Override
    public Stream<BlockState> streamBlockStates() {
        return Stream.of(this.block.defaultBlockState());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.block.equals(((BlockTypeIngredient)o).block);
    }

    @Override
    public String toString() {
        return "BlockTypeIngredient{" + String.valueOf(this.block) + "}";
    }

    public static class Type
    implements StateIngredientType<BlockTypeIngredient> {
        public static final MapCodec<BlockTypeIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(BlockTypeIngredient::block)).apply((Applicative)instance, BlockTypeIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockTypeIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), BlockTypeIngredient::block, BlockTypeIngredient::new);

        @Override
        public MapCodec<BlockTypeIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockTypeIngredient> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

