/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.recipe.StateIngredientType;
import vazkii.botania.common.crafting.StateIngredients;

public record BlockTagIngredient(TagKey<Block> tag) implements StateIngredient
{
    public Stream<Block> resolve() {
        return StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).spliterator(), false).map(Holder::value);
    }

    @Override
    public boolean test(BlockState state) {
        return state.is(this.tag);
    }

    @Override
    public BlockState pick(RandomSource random) {
        List<BlockState> blocks = this.getDisplayed();
        if (blocks.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return blocks.get(random.nextInt(blocks.size()));
    }

    public StateIngredientType getType() {
        return StateIngredients.BLOCK_TAG;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.resolve().filter(b -> b.asItem() != Items.AIR).map(ItemStack::new).toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.streamBlockStates().toList();
    }

    @Override
    public Stream<BlockState> streamBlockStates() {
        return this.resolve().map(Block::defaultBlockState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.tag.equals(((BlockTagIngredient)o).tag);
    }

    @Override
    public String toString() {
        return "BlockTagIngredient{" + String.valueOf(this.tag) + "}";
    }

    public static class Type
    implements StateIngredientType<BlockTagIngredient> {
        public static final MapCodec<BlockTagIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).fieldOf("tag").forGetter(BlockTagIngredient::tag)).apply((Applicative)instance, BlockTagIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockTagIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.map(id -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id), TagKey::location), BlockTagIngredient::tag, BlockTagIngredient::new);

        @Override
        public MapCodec<BlockTagIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockTagIngredient> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

