/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.recipe.StateIngredientType;
import vazkii.botania.common.crafting.StateIngredients;

public record BlockStateIngredient(BlockState state) implements StateIngredient
{
    @Override
    public boolean test(BlockState blockState) {
        return this.state == blockState;
    }

    @Override
    public BlockState pick(RandomSource random) {
        return this.state;
    }

    public StateIngredientType<BlockStateIngredient> getType() {
        return StateIngredients.BLOCK_STATE;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        Block block = this.state.getBlock();
        if (block.asItem() == Items.AIR) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ItemStack((ItemLike)block));
    }

    @Override
    @Nullable
    public List<Component> descriptionTooltip() {
        Map map = this.state.getValues();
        if (map.isEmpty()) {
            return StateIngredient.super.descriptionTooltip();
        }
        ArrayList<Component> tooltip = new ArrayList<Component>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Property key = (Property)entry.getKey();
            String name = key.getName((Comparable)entry.getValue());
            tooltip.add((Component)Component.literal((String)(key.getName() + " = " + name)).withStyle(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    @Override
    public List<BlockState> getDisplayed() {
        return Collections.singletonList(this.state);
    }

    @Override
    public Stream<BlockState> streamBlockStates() {
        return Stream.of(this.state);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.state == ((BlockStateIngredient)o).state;
    }

    @Override
    public String toString() {
        return "BlockStateIngredient{" + String.valueOf(this.state) + "}";
    }

    public static class Type
    implements StateIngredientType<BlockStateIngredient> {
        public static final MapCodec<BlockStateIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(BlockStateIngredient::state)).apply((Applicative)instance, BlockStateIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockStateIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(Block::stateById, Block::getId), BlockStateIngredient::state, BlockStateIngredient::new);

        @Override
        public MapCodec<BlockStateIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockStateIngredient> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

