/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.recipe.StateIngredientType;
import vazkii.botania.common.crafting.StateIngredients;

public class AnyOfStateIngredient
implements StateIngredient {
    private final ImmutableSet<StateIngredient> ingredients;

    public AnyOfStateIngredient(Collection<StateIngredient> blocks) {
        this.ingredients = ImmutableSet.copyOf(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(state));
    }

    @Override
    public BlockState pick(RandomSource random) {
        List<BlockState> states = this.streamBlockStates().filter(state -> state.is(Blocks.AIR)).toList();
        return states.isEmpty() ? Blocks.AIR.defaultBlockState() : states.get(random.nextInt(states.size()));
    }

    public StateIngredientType getType() {
        return StateIngredients.ANY_OF;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.streamBlockStates().filter(state -> state.is(Blocks.AIR)).map(BlockBehaviour.BlockStateBase::getBlock).map(ItemStack::new).toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.streamBlockStates().toList();
    }

    @Override
    public Stream<BlockState> streamBlockStates() {
        return this.ingredients.stream().flatMap(StateIngredient::streamBlockStates).distinct();
    }

    public ImmutableList<StateIngredient> getIngredients() {
        return this.ingredients.asList();
    }

    public String toString() {
        return "AnyOfStateIngredient{" + this.ingredients.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ingredients.equals(((AnyOfStateIngredient)o).ingredients);
    }

    public int hashCode() {
        return Objects.hash(this.ingredients);
    }

    public static class Type
    implements StateIngredientType<AnyOfStateIngredient> {
        public static final MapCodec<AnyOfStateIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)StateIngredients.TYPED_CODEC.listOf()).fieldOf("ingredients").forGetter(AnyOfStateIngredient::getIngredients)).apply((Applicative)instance, AnyOfStateIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnyOfStateIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)StateIngredients.TYPED_STREAM_CODEC.apply(ByteBufCodecs.list()), AnyOfStateIngredient::getIngredients, AnyOfStateIngredient::new);

        @Override
        public MapCodec<AnyOfStateIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AnyOfStateIngredient> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

