/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.recipe.StateIngredientType;
import vazkii.botania.common.crafting.StateIngredients;

public class AllOfExcludingStateIngredient
implements StateIngredient {
    private final ImmutableSet<StateIngredient> ingredients;
    private final ImmutableSet<StateIngredient> exclusions;
    private final Supplier<ImmutableList<BlockState>> resolvedBlocksStates = Suppliers.memoize(this::resolve);

    public AllOfExcludingStateIngredient(Collection<StateIngredient> ingredients, Collection<StateIngredient> exclusions) {
        this.ingredients = ImmutableSet.copyOf(ingredients);
        this.exclusions = ImmutableSet.copyOf(exclusions);
    }

    private ImmutableList<BlockState> resolve() {
        HashSet<BlockState> set = new HashSet<BlockState>(this.ingredients.stream().map(StateIngredient::streamBlockStates).map(stream -> new HashSet(stream.collect(Collectors.toSet()))).reduce((a, b) -> {
            a.retainAll((Collection<?>)b);
            return a;
        }).orElse(Collections.emptySet()));
        set.removeIf(state -> this.exclusions.stream().anyMatch(exclusion -> exclusion.test((BlockState)state)));
        return ImmutableList.copyOf(set);
    }

    @Override
    public boolean test(BlockState state) {
        return this.resolvedBlocksStates.get().contains((Object)state);
    }

    @Override
    public BlockState pick(RandomSource random) {
        ImmutableList<BlockState> states = this.resolvedBlocksStates.get();
        return states.isEmpty() ? Blocks.AIR.defaultBlockState() : (BlockState)states.get(random.nextInt(states.size()));
    }

    public StateIngredientType<AllOfExcludingStateIngredient> getType() {
        return StateIngredients.ALL_OF_EXCLUDING;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.streamBlockStates().filter(state -> state.is(Blocks.AIR)).map(BlockBehaviour.BlockStateBase::getBlock).map(ItemStack::new).toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return (List)this.resolvedBlocksStates.get();
    }

    @Override
    public Stream<BlockState> streamBlockStates() {
        return this.resolvedBlocksStates.get().stream();
    }

    public ImmutableList<StateIngredient> getIngredients() {
        return this.ingredients.asList();
    }

    public ImmutableList<StateIngredient> getExclusions() {
        return this.exclusions.asList();
    }

    public String toString() {
        return "AllOfExcludingStateIngredient{" + String.valueOf(this.getIngredients()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllOfExcludingStateIngredient that = (AllOfExcludingStateIngredient)o;
        return Objects.equals(this.ingredients, that.ingredients) && Objects.equals(this.exclusions, that.exclusions);
    }

    public int hashCode() {
        return Objects.hash(this.ingredients, this.exclusions);
    }

    public static class Type
    implements StateIngredientType<AllOfExcludingStateIngredient> {
        public static final MapCodec<AllOfExcludingStateIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)StateIngredients.TYPED_CODEC.listOf()).fieldOf("ingredients").forGetter(AllOfExcludingStateIngredient::getIngredients), (App)StateIngredients.TYPED_CODEC.listOf().optionalFieldOf("excluding", List.of()).forGetter(AllOfExcludingStateIngredient::getExclusions)).apply((Applicative)instance, AllOfExcludingStateIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AllOfExcludingStateIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)StateIngredients.TYPED_STREAM_CODEC.apply(ByteBufCodecs.list()), AllOfExcludingStateIngredient::getIngredients, (StreamCodec)StateIngredients.TYPED_STREAM_CODEC.apply(ByteBufCodecs.list()), AllOfExcludingStateIngredient::getExclusions, AllOfExcludingStateIngredient::new);

        @Override
        public MapCodec<AllOfExcludingStateIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AllOfExcludingStateIngredient> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

