/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum TooltipVisibility implements StringRepresentable
{
    HIDDEN(0, "hidden"),
    IN_NAME(1, "in_name"),
    IN_LIST(2, "in_list");

    private final int id;
    private final String name;
    public static final Codec<TooltipVisibility> CODEC;
    public static final IntFunction<TooltipVisibility> BY_ID;
    public static final StreamCodec<ByteBuf, TooltipVisibility> STREAM_CODEC;

    private TooltipVisibility(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromValues(TooltipVisibility::values);
        BY_ID = ByIdMap.continuous(visibility -> visibility.id, (Object[])TooltipVisibility.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, visibility -> visibility.id);
    }
}

