/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StoredIds {
    public static final StoredIds EMPTY = new StoredIds(new ResourceLocation[0]);
    public static final int MAX_SLOTS = 128;
    public static final Codec<StoredIds> CODEC = Slot.CODEC.sizeLimitedListOf(128).xmap(StoredIds::fromSlots, StoredIds::getPopulatedSlots);
    public static final StreamCodec<ByteBuf, StoredIds> STREAM_CODEC = Slot.STREAM_CODEC.apply(ByteBufCodecs.list((int)128)).map(StoredIds::fromSlots, StoredIds::getPopulatedSlots);
    @Nullable
    private final ResourceLocation[] ids;
    private final int cachedHashCode;

    private static StoredIds fromSlots(List<Slot> slots) {
        OptionalInt lastSlotIndex = slots.stream().mapToInt(Slot::index).max();
        if (lastSlotIndex.isEmpty()) {
            return EMPTY;
        }
        ResourceLocation[] ids = new ResourceLocation[lastSlotIndex.getAsInt() + 1];
        for (Slot slot : slots) {
            ids[slot.index] = slot.value;
        }
        return new StoredIds(ids);
    }

    private static List<Slot> getPopulatedSlots(StoredIds storedIds) {
        ResourceLocation[] ids = storedIds.ids;
        ArrayList<Slot> slots = new ArrayList<Slot>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            slots.add(new Slot(i, ids[i]));
        }
        return slots;
    }

    private StoredIds(ResourceLocation[] idsToStore) {
        this.ids = idsToStore;
        this.cachedHashCode = Arrays.hashCode(idsToStore);
    }

    public StoredIds store(int slot, @Nullable ResourceLocation newId) {
        if (slot < 0 || slot >= 128) {
            throw new IndexOutOfBoundsException("Slot index must be positive and less than 128, but was " + slot);
        }
        if (slot < this.ids.length && Objects.equals(this.ids[slot], newId)) {
            return this;
        }
        int newLength = this.getNewLength(slot, newId);
        if (newLength == 0) {
            return EMPTY;
        }
        ResourceLocation[] idsCopy = Arrays.copyOf(this.ids, newLength);
        if (slot < newLength) {
            idsCopy[slot] = newId;
        }
        return new StoredIds(idsCopy);
    }

    private int getNewLength(int slot, @Nullable ResourceLocation newId) {
        if (newId != null) {
            return Math.max(this.ids.length, slot + 1);
        }
        if (slot == this.ids.length - 1) {
            int newLastSlot = slot;
            while (--newLastSlot >= 0 && this.ids[newLastSlot] == null) {
            }
            return newLastSlot + 1;
        }
        return this.ids.length;
    }

    @Nullable
    public ResourceLocation getSlot(int slot) {
        return slot >= 0 && slot < this.ids.length ? this.ids[slot] : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredIds)) {
            return false;
        }
        StoredIds that = (StoredIds)o;
        return Arrays.equals(this.ids, that.ids);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public record Slot(int index, ResourceLocation value) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)128).fieldOf("index").forGetter(Slot::index), (App)ResourceLocation.CODEC.fieldOf("value").forGetter(Slot::value)).apply((Applicative)instance, Slot::new));
        public static final StreamCodec<ByteBuf, Slot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Slot::index, (StreamCodec)ResourceLocation.STREAM_CODEC, Slot::value, Slot::new);
    }
}

