/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.component;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.component.StoredIds;

public class BotaniaDataComponents {
    private static final Map<String, DataComponentType<?>> ALL = new HashMap();
    public static final DataComponentType<Unit> ACTIVE = BotaniaDataComponents.makeUnit("active");
    public static final DataComponentType<Unit> ACTIVE_TRANSIENT = BotaniaDataComponents.makeTransientUnit("active_transient");
    public static final DataComponentType<Unit> PHANTOM_INKED = BotaniaDataComponents.makeUnit("phantom_inked");
    public static final DataComponentType<Unit> RESOLUTE_IVY = BotaniaDataComponents.makeUnit("resolute_ivy");
    public static final DataComponentType<Unit> ELEMENTIUM_TIPPED = BotaniaDataComponents.makeUnit("elementium_tipped");
    public static final DataComponentType<Unit> ELVEN_UNLOCK = BotaniaDataComponents.makeUnit("elven_unlock");
    public static final DataComponentType<Unit> RENDER_FULL = BotaniaDataComponents.makeTransientUnit("render_full");
    public static final DataComponentType<DyeColor> WAND_COLOR1 = BotaniaDataComponents.make("wand_color1", builder -> builder.persistent((Codec)DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<DyeColor> WAND_COLOR2 = BotaniaDataComponents.make("wand_color2", builder -> builder.persistent((Codec)DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<Unit> WAND_BIND_MODE = BotaniaDataComponents.makeUnit("wand_bind_mode");
    public static final DataComponentType<GlobalPos> BINDING_POS = BotaniaDataComponents.make("binding_pos", builder -> builder.persistent(GlobalPos.CODEC).networkSynchronized(GlobalPos.STREAM_CODEC));
    public static final DataComponentType<Integer> MANA = BotaniaDataComponents.make("mana", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MAX_MANA = BotaniaDataComponents.make("max_mana", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MANA_BACKLOG = BotaniaDataComponents.make("mana_backlog", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unit> CAN_RECEIVE_MANA_FROM_ITEM = BotaniaDataComponents.makeUnit("can_receive_mana_from_item");
    public static final DataComponentType<Unit> CAN_RECEIVE_MANA_FROM_POOL = BotaniaDataComponents.makeUnit("can_receive_mana_from_pool");
    public static final DataComponentType<Unit> CAN_EXPORT_MANA_TO_ITEM = BotaniaDataComponents.makeUnit("can_export_mana_to_item");
    public static final DataComponentType<Unit> CAN_EXPORT_MANA_TO_POOL = BotaniaDataComponents.makeUnit("can_export_mana_to_pool");
    public static final DataComponentType<Unit> CREATIVE_MANA = BotaniaDataComponents.makeUnit("creative_mana");
    public static final DataComponentType<GlobalPos> MANA_POOL_POS = BotaniaDataComponents.make("mana_pool_pos", builder -> builder.persistent(GlobalPos.CODEC).networkSynchronized(GlobalPos.STREAM_CODEC));
    public static final DataComponentType<Float> HALO_ROTATION_BASE = BotaniaDataComponents.make("halo_rotation_base", builder -> builder.networkSynchronized(ByteBufCodecs.FLOAT));
    public static final DataComponentType<ResourceLocation> LAST_RECIPE_ID = BotaniaDataComponents.make("last_recipe_id", builder -> builder.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DataComponentType<StoredIds> STORED_RECIPES = BotaniaDataComponents.make("stored_recipes", builder -> builder.persistent(StoredIds.CODEC).cacheEncoding().networkSynchronized(StoredIds.STREAM_CODEC));
    public static final DataComponentType<Long> LAST_TRIGGER_TIME = BotaniaDataComponents.make("last_trigger_time", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DataComponentType<DyeColor> LENS_TINT = BotaniaDataComponents.make("lens_tint", builder -> builder.persistent((Codec)DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<Unit> LENS_RAINBOW_TINT = BotaniaDataComponents.makeUnit("lens_rainbow_tint");
    public static final DataComponentType<ItemStack> ATTACHED_LENS = BotaniaDataComponents.make("attached_lens", builder -> builder.persistent(ItemStack.CODEC).cacheEncoding().networkSynchronized(ItemStack.STREAM_CODEC));
    public static final DataComponentType<ResourceLocation> BREW = BotaniaDataComponents.make("brew", builder -> builder.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DataComponentType<Integer> MAX_USES = BotaniaDataComponents.make("max_uses", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> REMAINING_USES = BotaniaDataComponents.make("remaining_uses", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Long> RANDOM_SEED = BotaniaDataComponents.make("random_seed", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized((StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Long>(){

        public Long decode(RegistryFriendlyByteBuf buffer) {
            return buffer.readLong();
        }

        public void encode(RegistryFriendlyByteBuf buffer, Long value) {
            buffer.writeLong(value.longValue());
        }
    }));
    public static final DataComponentType<List<Integer>> SPECTATOR_HIGHLIGHT_ENTITIES = BotaniaDataComponents.make("spectator_highlight_entities", builder -> builder.networkSynchronized(ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list())));
    public static final DataComponentType<List<BlockPos>> SPECTATOR_HIGHLIGHT_BLOCKS = BotaniaDataComponents.make("spectator_highlight_blocks", builder -> builder.networkSynchronized(BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list())));
    public static final DataComponentType<ResourceLocation> BLOCK_TYPE = BotaniaDataComponents.make("block_type", builder -> builder.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DataComponentType<Integer> BLOCK_COUNT = BotaniaDataComponents.make("block_count", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> RANGE = BotaniaDataComponents.make("range", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<ResourceLocation> MOB_TYPE = BotaniaDataComponents.make("mob_type", builder -> builder.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DataComponentType<Integer> NOT_MY_NAME_STEP = BotaniaDataComponents.make("not_my_name_step", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));

    public static void registerComponents(BiConsumer<DataComponentType<?>, ResourceLocation> biConsumer) {
        for (Map.Entry<String, DataComponentType<?>> entry : ALL.entrySet()) {
            biConsumer.accept(entry.getValue(), BotaniaAPI.botaniaRL(entry.getKey()));
        }
    }

    private static <T> DataComponentType<T> make(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        if (!name.matches("[a-z]+(?:_[a-z0-9]+)*")) {
            throw new IllegalArgumentException("Typo? Name should be in snake_case: " + name);
        }
        DataComponentType type = ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build();
        DataComponentType old = ALL.put(name, type);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate name " + name);
        }
        return type;
    }

    private static DataComponentType<Unit> makeUnit(String name) {
        return BotaniaDataComponents.make(name, builder -> builder.persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));
    }

    private static DataComponentType<Unit> makeTransientUnit(String name) {
        return BotaniaDataComponents.make(name, builder -> builder.networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));
    }
}

