/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.brew;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.brew.effect.AbsolutionMobEffect;
import vazkii.botania.common.brew.effect.AllureMobEffect;
import vazkii.botania.common.brew.effect.BloodthirstMobEffect;
import vazkii.botania.common.brew.effect.EmptinessMobEffect;
import vazkii.botania.common.brew.effect.FeatherfeetMobEffect;
import vazkii.botania.common.brew.effect.SoulCrossMobEffect;

public class BotaniaMobEffects {
    private static final Map<String, MobEffect> toRegister = new HashMap<String, MobEffect>();
    public static final Holder<MobEffect> SOUL_CROSS = BotaniaMobEffects.schedule("soul_cross", new SoulCrossMobEffect());
    public static final Holder<MobEffect> FEATHER_FEET = BotaniaMobEffects.schedule("feather_feet", new FeatherfeetMobEffect());
    public static final Holder<MobEffect> EMPTINESS = BotaniaMobEffects.schedule("emptiness", new EmptinessMobEffect());
    public static final Holder<MobEffect> BLOODTHRST = BotaniaMobEffects.schedule("bloodthrst", new BloodthirstMobEffect());
    public static final Holder<MobEffect> ALLURE = BotaniaMobEffects.schedule("allure", new AllureMobEffect());
    public static final Holder<MobEffect> CLEAR = BotaniaMobEffects.schedule("clear", (MobEffect)new AbsolutionMobEffect());

    private static Holder<MobEffect> schedule(String name, MobEffect effect) {
        toRegister.put(name, effect);
        return Holder.direct((Object)effect);
    }

    public static void registerPotions(BiConsumer<MobEffect, ResourceLocation> r) {
        for (Map.Entry<String, MobEffect> entry : toRegister.entrySet()) {
            r.accept(entry.getValue(), BotaniaAPI.botaniaRL(entry.getKey()));
        }
    }
}

