/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPrismBlockEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class ManaPrismBlock
extends BotaniaWaterloggedBlock
implements EntityBlock,
ManaCollisionGhost {
    private static final VoxelShape SHAPE = ManaPrismBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public ManaPrismBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BotaniaStateProperties.HAS_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).getEntity() instanceof ManaBurstEntity) {
            return SHAPE;
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            ManaPrismBlock.redstoneParticlesInShape(state, world, pos, rand);
        }
    }

    public static void redstoneParticlesInShape(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (rand.nextBoolean()) {
            AABB localBox = state.getShape((BlockGetter)world, pos).bounds();
            double x = (double)pos.getX() + localBox.minX + rand.nextDouble() * (localBox.maxX - localBox.minX);
            double y = (double)pos.getY() + localBox.minY + rand.nextDouble() * (localBox.maxY - localBox.minY);
            double z = (double)pos.getZ() + localBox.minZ + rand.nextDouble() * (localBox.maxZ - localBox.minZ);
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED, BotaniaStateProperties.HAS_LENS});
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof ManaPrismBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ManaPrismBlockEntity prism = (ManaPrismBlockEntity)tile;
        ItemStack lens = prism.getItemHandler().getItem(0);
        boolean playerHasLens = !heldItem.isEmpty() && heldItem.getItem() instanceof BasicLensItem;
        boolean lensIsSame = playerHasLens && ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)lens);
        boolean mainHandEmpty = player.getMainHandItem().isEmpty();
        if (playerHasLens && !lensIsSame) {
            ItemStack toInsert = heldItem.split(1);
            if (!lens.isEmpty()) {
                player.getInventory().placeItemBackInInventory(lens);
            }
            prism.getItemHandler().setItem(0, toInsert);
            world.playSound(player, pos, BotaniaSounds.prismAddLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!lens.isEmpty() && (mainHandEmpty || lensIsSame)) {
            player.getInventory().placeItemBackInInventory(lens);
            prism.getItemHandler().setItem(0, ItemStack.EMPTY);
            world.playSound(player, pos, BotaniaSounds.prismRemoveLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        boolean power = world.getBestNeighborSignal(pos = context.getClickedPos()) > 0;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(power));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.getBestNeighborSignal(pos) > 0;
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (!world.isClientSide) {
            if (power && !powered) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (!power && powered) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaPrismBlockEntity(pos, state);
    }

    @Override
    public ManaCollisionGhost.Behaviour getGhostBehaviour() {
        return ManaCollisionGhost.Behaviour.RUN_RECEIVER_TRIGGER;
    }
}

