/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class ManaPoolBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape NORMAL_SHAPE;
    private static final VoxelShape DILUTED_SHAPE;
    private static final VoxelShape CREATIVE_SHAPE;
    private static final VoxelShape NORMAL_SHAPE_INTERACT;
    private static final VoxelShape DILUTED_SHAPE_INTERACT;
    private static final VoxelShape CREATIVE_SHAPE_INTERACT;
    public final Variant variant;

    public ManaPoolBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)((Object)BotaniaStateProperties.OptionalDyeColor.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BotaniaStateProperties.OPTIONAL_DYE_COLOR});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (this.variant == Variant.CREATIVE) {
            for (int i = 0; i < 2; ++i) {
                tooltip.add((Component)Component.translatable((String)("botaniamisc.creativePool" + i)).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch (this.variant.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> DILUTED_SHAPE;
            case 1 -> CREATIVE_SHAPE;
            case 0, 3 -> NORMAL_SHAPE;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).getEntity() instanceof ManaBurstEntity) {
            return switch (this.variant.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> DILUTED_SHAPE_INTERACT;
                case 1 -> CREATIVE_SHAPE_INTERACT;
                case 0, 3 -> NORMAL_SHAPE_INTERACT;
            };
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    @NotNull
    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return switch (this.variant.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> DILUTED_SHAPE_INTERACT;
            case 1 -> CREATIVE_SHAPE_INTERACT;
            case 0, 3 -> NORMAL_SHAPE_INTERACT;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ManaPoolBlockEntity pool;
        BlockEntity be = level.getBlockEntity(pos);
        Optional<Object> itemColor = Optional.empty();
        Item item = stack.getItem();
        if (item instanceof MysticalPetalItem) {
            MysticalPetalItem petalItem = (MysticalPetalItem)item;
            itemColor = Optional.of(petalItem.color);
        }
        if ((item = Block.byItem((Item)stack.getItem())) instanceof BotaniaMushroomBlock) {
            BotaniaMushroomBlock mushroomBlock = (BotaniaMushroomBlock)item;
            itemColor = Optional.of(mushroomBlock.color);
        }
        if (itemColor.isPresent() && be instanceof ManaPoolBlockEntity && !itemColor.equals((pool = (ManaPoolBlockEntity)be).getColor())) {
            pool.setColor(itemColor);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.is(Items.CLAY_BALL) && be instanceof ManaPoolBlockEntity && (pool = (ManaPoolBlockEntity)be).getColor().isPresent()) {
            pool.setColor(Optional.empty());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaPoolBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaPoolBlock.createTickerHelper(type, BotaniaBlockEntities.POOL, level.isClientSide ? ManaPoolBlockEntity::clientTick : ManaPoolBlockEntity::serverTick);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            ManaPoolBlockEntity tile = (ManaPoolBlockEntity)world.getBlockEntity(pos);
            tile.collideEntityItem(item);
        }
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        if (this.variant == Variant.FABULOUS) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        ManaPoolBlockEntity pool = (ManaPoolBlockEntity)world.getBlockEntity(pos);
        return ManaPoolBlockEntity.calculateComparatorLevel(pool.getCurrentMana(), pool.getMaxMana());
    }

    static {
        NORMAL_SHAPE_INTERACT = ManaPoolBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        DILUTED_SHAPE_INTERACT = ManaPoolBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        CREATIVE_SHAPE_INTERACT = ManaPoolBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape cutout = ManaPoolBlock.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        VoxelShape dilutedCutout = ManaPoolBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        NORMAL_SHAPE = Shapes.join((VoxelShape)NORMAL_SHAPE_INTERACT, (VoxelShape)cutout, (BooleanOp)BooleanOp.ONLY_FIRST);
        DILUTED_SHAPE = Shapes.join((VoxelShape)DILUTED_SHAPE_INTERACT, (VoxelShape)dilutedCutout, (BooleanOp)BooleanOp.ONLY_FIRST);
        CREATIVE_SHAPE = Shapes.join((VoxelShape)CREATIVE_SHAPE_INTERACT, (VoxelShape)cutout, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    public static enum Variant {
        DEFAULT,
        CREATIVE,
        DILUTED,
        FABULOUS;

    }
}

