/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaEnchanterBlock
extends BotaniaBlock
implements EntityBlock {
    public ManaEnchanterBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(BotaniaStateProperties.ENCHANTER_DIRECTION, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BotaniaStateProperties.ENCHANTER_DIRECTION});
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaEnchanterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaEnchanterBlock.createTickerHelper(type, BotaniaBlockEntities.ENCHANTER, ManaEnchanterBlockEntity::commonTick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean stackEnchantable;
        ManaEnchanterBlockEntity enchanter = (ManaEnchanterBlockEntity)world.getBlockEntity(pos);
        if (!stack.isEmpty() && stack.getItem() instanceof WandOfTheForestItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean bl = stackEnchantable = !stack.isEmpty() && !stack.is(Items.BOOK) && stack.isEnchantable() && stack.getCount() == 1;
        if (enchanter.itemToEnchant.isEmpty()) {
            if (!stackEnchantable) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            enchanter.itemToEnchant = stack.copy();
            player.setItemInHand(hand, ItemStack.EMPTY);
            enchanter.sync();
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        } else {
            if (enchanter.stage != ManaEnchanterBlockEntity.State.IDLE) return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            player.getInventory().placeItemBackInInventory(enchanter.itemToEnchant.copy());
            enchanter.itemToEnchant = ItemStack.EMPTY;
            enchanter.sync();
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof ManaEnchanterBlockEntity) {
                ManaEnchanterBlockEntity enchanter = (ManaEnchanterBlockEntity)tile;
                if (!enchanter.itemToEnchant.isEmpty()) {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)enchanter.itemToEnchant);
                }
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }
}

