/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.HornItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.LivingEntityAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class DrumBlock
extends BotaniaWaterloggedBlock {
    public static final int MAX_NUM_SHEARED = 4;
    public static final int GATHER_RANGE = 10;
    public static final int MINIMUM_REMAINING_EGG_TIME = 600;
    public static final int STARTLED_EGG_TIME = 200;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public DrumBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static void gatherProduce(Level world, BlockPos pos) {
        List mobs = world.getEntitiesOfClass(Mob.class, new AABB(pos).inflate(10.0), mob -> mob.isAlive() && !BergamuteBlockEntity.isBergamuteNearby(world, mob.getX(), mob.getY(), mob.getZ()));
        ArrayList<Shearable> shearables = new ArrayList<Shearable>();
        for (Mob mob2 : mobs) {
            MushroomCow mooshroom;
            Chicken chicken;
            if (mob2 instanceof Chicken && !(chicken = (Chicken)mob2).isBaby() && !chicken.isChickenJockey()) {
                DrumBlock.speedUpEggLaying(chicken);
            }
            if (mob2.getType().is(BotaniaTags.Entities.DRUM_MILKABLE) && !mob2.isBaby()) {
                DrumBlock.convertNearby(mob2, Items.BUCKET, Items.MILK_BUCKET);
            }
            if (mob2 instanceof MushroomCow && !(mooshroom = (MushroomCow)mob2).isBaby()) {
                if (mooshroom.getVariant() == MushroomCow.MushroomType.BROWN) {
                    DrumBlock.fillBowlSuspiciously(mooshroom);
                }
                DrumBlock.convertNearby(mob2, Items.BOWL, Items.MUSHROOM_STEW);
            }
            if (!(mob2 instanceof Shearable)) continue;
            Shearable shearable = (Shearable)mob2;
            if (mob2.getType().is(BotaniaTags.Entities.DRUM_NO_SHEARING) || !shearable.readyForShearing()) continue;
            shearables.add(shearable);
        }
        Collections.shuffle(shearables);
        int sheared = 0;
        for (Shearable shearable : shearables) {
            if (sheared > 4) break;
            shearable.shear(SoundSource.BLOCKS);
            ++sheared;
        }
    }

    private static void speedUpEggLaying(Chicken chicken) {
        if (chicken.eggTime > 600) {
            chicken.eggTime = Math.max(600, chicken.eggTime / 2);
        } else if (chicken.eggTime < 200 && chicken.eggTime > 1) {
            chicken.eggTime = 1;
            ((LivingEntityAccessor)chicken).botania_playHurtSound(chicken.damageSources().magic());
        }
    }

    private static void convertNearby(Mob mob, Item from, Item to) {
        Level world = mob.level();
        List fromEntities = world.getEntitiesOfClass(ItemEntity.class, mob.getBoundingBox(), itemEntity -> itemEntity.isAlive() && itemEntity.getItem().is(from));
        for (ItemEntity fromEntity : fromEntities) {
            ItemStack fromStack = fromEntity.getItem();
            for (int i = fromStack.getCount(); i > 0; --i) {
                DrumBlock.spawnItem(mob, new ItemStack((ItemLike)to));
            }
            fromEntity.discard();
        }
    }

    private static void spawnItem(Mob mob, ItemStack to) {
        Level world = mob.level();
        ItemEntity ent = mob.spawnAtLocation(to, 1.0f);
        ent.setDeltaMovement(ent.getDeltaMovement().add((double)(world.random.nextFloat() * 0.05f), (double)((world.random.nextFloat() - world.random.nextFloat()) * 0.1f), (double)((world.random.nextFloat() - world.random.nextFloat()) * 0.1f)));
    }

    private static void fillBowlSuspiciously(MushroomCow mushroomCow) {
        block2: {
            MushroomCowAccessor mushroomCowAccessor = (MushroomCowAccessor)mushroomCow;
            SuspiciousStewEffects stewEffects = mushroomCowAccessor.getStewEffects();
            if (stewEffects == null) {
                return;
            }
            Level world = mushroomCow.level();
            List bowlItemEntities = world.getEntitiesOfClass(ItemEntity.class, mushroomCow.getBoundingBox(), itemEntity -> itemEntity.getItem().is(Items.BOWL) && !itemEntity.getItem().isEmpty());
            Iterator iterator = bowlItemEntities.iterator();
            if (!iterator.hasNext()) break block2;
            ItemEntity bowlItemEntity = (ItemEntity)iterator.next();
            ItemStack bowlItem = bowlItemEntity.getItem();
            ItemStack stewItem = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
            stewItem.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)mushroomCowAccessor.getStewEffects());
            DrumBlock.spawnItem((Mob)mushroomCow, stewItem);
            EntityHelper.shrinkItem(bowlItemEntity);
            if (bowlItem.getCount() == 0) {
                bowlItemEntity.discard();
            }
            mushroomCowAccessor.setStewEffects(null);
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }

    public static class ManaTriggerImpl
    implements ManaTrigger {
        private final Level world;
        private final BlockPos pos;
        private final Variant variant;

        public ManaTriggerImpl(Level world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.variant = ((DrumBlock)state.getBlock()).variant;
        }

        @Override
        public void onBurstCollision(ManaBurst burst) {
            if (burst.isFake()) {
                return;
            }
            if (this.world.isClientSide) {
                this.world.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.2, (double)this.pos.getZ() + 0.5, 0.041666666666666664, 0.0, 0.0);
                return;
            }
            switch (this.variant.ordinal()) {
                case 0: {
                    HornItem.breakGrass(this.world, new ItemStack((ItemLike)BotaniaItems.grassHorn), this.pos, null);
                    break;
                }
                case 2: {
                    HornItem.breakGrass(this.world, new ItemStack((ItemLike)BotaniaItems.leavesHorn), this.pos, null);
                    break;
                }
                case 1: {
                    DrumBlock.gatherProduce(this.world, this.pos);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.world.playSound(null, this.pos, BotaniaSounds.drum, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

