/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.DelayHelper;

public class SpectrolusBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_NEXT_COLOR = "nextColor";
    private static final int WOOL_GEN = 1200;
    private static final int SHEEP_GEN = 5000;
    private static final int BABY_SHEEP_GEN = 1;
    private static final int RANGE = 1;
    private DyeColor nextColor = DyeColor.WHITE;

    public SpectrolusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SPECTROLUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        List sheeps = this.getLevel().getEntitiesOfClass(Sheep.class, new AABB(this.getEffectivePos()), Entity::isAlive);
        AABB itemAABB = new AABB(this.getEffectivePos()).inflate(1.0);
        Predicate<ItemEntity> selector = e -> DelayHelper.canInteractWithImmediate(this, e);
        List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, itemAABB, selector);
        for (Entity target : Iterables.concat((Iterable)sheeps, (Iterable)items)) {
            ItemEntity item;
            ItemStack stack;
            if (target instanceof Sheep) {
                Sheep sheep = (Sheep)target;
                if (!sheep.isSheared() && sheep.getColor() == this.nextColor) {
                    this.addManaAndCycle(sheep.isBaby() ? 1 : 5000);
                    float pitch = sheep.isBaby() ? (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.5f : (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f;
                    sheep.playSound(SoundEvents.SHEEP_DEATH, 0.9f, pitch);
                    sheep.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                    ItemStack morbid = new ItemStack((ItemLike)(sheep.isOnFire() ? Items.COOKED_MUTTON : Items.MUTTON));
                    ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, morbid), target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 20, 0.1, 0.1, 0.1, 0.05);
                    ItemStack wool = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(sheep.getColor()));
                    ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, wool), target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 20, 0.1, 0.1, 0.1, 0.05);
                }
                sheep.setHealth(0.0f);
                continue;
            }
            if (!(target instanceof ItemEntity) || (stack = (item = (ItemEntity)target).getItem()).isEmpty() || !ColorHelper.isWool(Block.byItem((Item)stack.getItem()))) continue;
            Block expected = ColorHelper.WOOL_MAP.apply(this.nextColor);
            if (expected.asItem() == stack.getItem()) {
                this.addManaAndCycle(1200);
                ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), target.getX(), target.getY(), target.getZ(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            target.discard();
        }
    }

    private void addManaAndCycle(int toAdd) {
        this.addMana(toAdd);
        this.nextColor = this.nextColor == DyeColor.BLACK ? DyeColor.WHITE : DyeColor.byId((int)(this.nextColor.getId() + 1));
        this.sync();
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public int getColor() {
        return ColorHelper.getColorLegibleOnGrayBackground(this.nextColor);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_NEXT_COLOR, this.nextColor.ordinal());
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.nextColor = DyeColor.byId((int)cmp.getInt(TAG_NEXT_COLOR));
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<SpectrolusBlockEntity> {
        public WandHud(SpectrolusBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack stack = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(((SpectrolusBlockEntity)this.flower).nextColor));
            if (stack.isEmpty()) {
                super.renderHUD(gui, mc);
            } else {
                int halfWidth = RenderHelper.itemWithNameWidth(mc, stack) / 2;
                int centerY = mc.getWindow().getGuiScaledHeight() / 2;
                super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
                RenderHelper.renderItemWithNameCentered(gui, mc, stack, centerY + 30, ColorHelper.getColorLegibleOnGrayBackground(((SpectrolusBlockEntity)this.flower).nextColor));
            }
        }
    }
}

