/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

public class ShulkMeNotBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RADIUS = 8;

    public ShulkMeNotBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SHULK_ME_NOT, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int generate = this.getMaxMana();
        Level world = this.getLevel();
        BlockPos pos = this.getEffectivePos();
        Vec3 posD = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!world.isClientSide) {
            List shulkers = world.getEntitiesOfClass(Shulker.class, new AABB(pos).inflate(8.0));
            for (Shulker shulker : shulkers) {
                LivingEntity target;
                if (this.getMaxMana() - this.getMana() < generate) break;
                if (!shulker.isAlive() || !(shulker.distanceToSqr(posD) < 64.0) || !((target = shulker.getTarget()) instanceof Enemy) || !target.isAlive() || !(target.distanceToSqr(posD) < 64.0) || target.getEffect(MobEffects.LEVITATION) == null) continue;
                target.discard();
                shulker.discard();
                for (int i = 0; i < 10; ++i) {
                    world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, BotaniaSounds.shulkMeNot, SoundSource.BLOCKS, 10.0f, 1.0f);
                }
                this.particles(world, pos, (Entity)target);
                this.particles(world, pos, (Entity)shulker);
                world.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                this.addMana(generate);
                this.sync();
            }
        }
    }

    private void particles(Level world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            ws.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX() + (double)(entity.getBbWidth() / 2.0f), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ() + (double)(entity.getBbWidth() / 2.0f), 100, (double)entity.getBbWidth(), (double)entity.getBbHeight(), (double)entity.getBbWidth(), 0.05);
            ws.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 40, 0.0, 0.0, 0.0, 0.6);
        }
    }

    @Override
    public int getColor() {
        return 8476056;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 8.0);
    }

    @Override
    public int getMaxMana() {
        return 75000;
    }
}

