/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.ExperienceOrbAccessor;

public class RosaArcanaBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int MANA_PER_XP = 50;
    private static final int RANGE = 1;

    public RosaArcanaBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.ROSA_ARCANA, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.level.isClientSide || this.getMana() >= this.getMaxMana()) {
            return;
        }
        AABB effectBounds = new AABB(this.getEffectivePos()).inflate(1.0);
        List players = this.getLevel().getEntitiesOfClass(Player.class, effectBounds);
        for (Object player : players) {
            if (((Player)player).experienceLevel <= 0 && !(((Player)player).experienceProgress > 0.0f) || !player.onGround()) continue;
            player.giveExperiencePoints(-1);
            this.addMana(50);
            this.sync();
            return;
        }
        List orbs = this.getLevel().getEntitiesOfClass(ExperienceOrb.class, effectBounds);
        for (ExperienceOrb orb : orbs) {
            int count = ((ExperienceOrbAccessor)orb).botania_getCount();
            if (!orb.isAlive() || count <= 0) continue;
            this.addMana(orb.getValue() * 50);
            ((ExperienceOrbAccessor)orb).botania_setCount(count - 1);
            if (count == 1) {
                orb.discard();
            }
            float pitch = (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.35f + 0.9f;
            this.level.playSound(null, this.getEffectivePos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.07f, pitch);
            this.sync();
            return;
        }
        List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, effectBounds, e -> e.isAlive() && !e.getItem().isEmpty());
        for (ItemEntity entity : items) {
            int xp;
            ItemStack stack = entity.getItem();
            if (!stack.is(Items.ENCHANTED_BOOK) && !stack.isEnchanted() || (xp = RosaArcanaBlockEntity.getEnchantmentXpValue(stack)) <= 0) continue;
            ItemStack newStack = RosaArcanaBlockEntity.removeNonCurses(stack);
            newStack.setCount(1);
            EntityHelper.shrinkItem(entity);
            ItemEntity newEntity = new ItemEntity(this.level, entity.getX(), entity.getY(), entity.getZ(), newStack);
            newEntity.setDeltaMovement(entity.getDeltaMovement());
            this.level.addFreshEntity((Entity)newEntity);
            this.level.playSound(null, this.getEffectivePos(), BotaniaSounds.arcaneRoseDisenchant, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
            while (xp > 0) {
                int i = ExperienceOrb.getExperienceValue((int)xp);
                xp -= i;
                this.level.addFreshEntity((Entity)new ExperienceOrb(this.level, (double)this.getEffectivePos().getX() + 0.5, (double)this.getEffectivePos().getY() + 0.5, (double)this.getEffectivePos().getZ() + 0.5, i));
            }
            return;
        }
    }

    private static int getEnchantmentXpValue(ItemStack stack) {
        int ret = 0;
        ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            int integer = entry.getIntValue();
            if (holder.is(EnchantmentTags.CURSE)) continue;
            ret += ((Enchantment)holder.value()).getMinCost(integer);
        }
        return ret;
    }

    private static ItemStack removeNonCurses(ItemStack stack) {
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments((ItemStack)stack, p_330066_ -> p_330066_.removeIf(p_344368_ -> !p_344368_.is(EnchantmentTags.CURSE)));
        if (stack.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            stack = stack.transmuteCopy((ItemLike)Items.BOOK);
        }
        int i = 0;
        for (int j = 0; j < itemenchantments.size(); ++j) {
            i = AnvilMenu.calculateIncreasedRepairCost((int)i);
        }
        stack.set(DataComponents.REPAIR_COST, (Object)i);
        return stack;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getColor() {
        return 0xFF8EF8;
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }
}

