/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

public class MunchdewBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_ATE_ONCE = "ateOnce";
    private static final int RANGE = 8;
    private static final int RANGE_Y = 16;
    private boolean ateOnce = false;
    private int ticksWithoutEating = -1;
    private int cooldown = 0;

    public MunchdewBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.MUNCHDEW, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            this.ticksWithoutEating = 0;
            this.ateOnce = false;
            return;
        }
        int manaPerLeaf = 160;
        if (this.getMaxMana() - this.getMana() >= manaPerLeaf && this.ticksExisted % 4 == 0) {
            HashMap<BlockPos, Float> coordsMap = new HashMap<BlockPos, Float>();
            Random rng = new Random();
            BlockPos pos = this.getEffectivePos();
            block0: for (Object pos_ : BlockPos.betweenClosed((BlockPos)pos.offset(-8, 0, -8), (BlockPos)pos.offset(8, 16, 8))) {
                BlockState state = this.getLevel().getBlockState((BlockPos)pos_);
                if (!state.is(BlockTags.LEAVES)) continue;
                for (Direction dir : Direction.values()) {
                    if (!this.getLevel().isEmptyBlock(pos_.relative(dir))) continue;
                    coordsMap.put(pos_.immutable(), Float.valueOf((float)(state.hasProperty((Property)LeavesBlock.DISTANCE) ? (Integer)state.getValue((Property)LeavesBlock.DISTANCE) : 1) + 2.0f * rng.nextFloat()));
                    continue block0;
                }
            }
            if (!coordsMap.isEmpty()) {
                Object pos_;
                float maxDistance = 0.0f;
                pos_ = coordsMap.values().iterator();
                while (pos_.hasNext()) {
                    float distance = ((Float)pos_.next()).floatValue();
                    maxDistance = Math.max(maxDistance, distance);
                }
                float finalMaxDistance = maxDistance;
                coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
                ArrayList coords = new ArrayList(coordsMap.keySet());
                BlockPos breakCoords = (BlockPos)coords.get(this.level.getRandom().nextInt(coords.size()));
                BlockState state = this.getLevel().getBlockState(breakCoords);
                this.getLevel().removeBlock(breakCoords, false);
                this.ticksWithoutEating = 0;
                this.ateOnce = true;
                if (BotaniaConfig.common().blockBreakParticles()) {
                    this.getLevel().levelEvent(2001, breakCoords, Block.getId((BlockState)state));
                }
                this.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_DESTROY, breakCoords);
                this.addMana(manaPerLeaf);
            }
        }
        if (this.ateOnce) {
            ++this.ticksWithoutEating;
            if (this.ticksWithoutEating >= 5) {
                this.cooldown = 1600;
                this.sync();
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 8);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_COOLDOWN, this.cooldown);
        cmp.putBoolean(TAG_ATE_ONCE, this.ateOnce);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.cooldown = cmp.getInt(TAG_COOLDOWN);
        this.ateOnce = cmp.getBoolean(TAG_ATE_ONCE);
    }

    @Override
    public int getColor() {
        return 7980079;
    }

    @Override
    public int getMaxMana() {
        return 10000;
    }
}

