/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class KekimurusBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 5;

    public KekimurusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.KEKIMURUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        int mana = 1800;
        if (this.getMaxMana() - this.getMana() >= mana && !this.getLevel().isClientSide && this.ticksExisted % 80 == 0) {
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int k = 0; k < 11; ++k) {
                        BlockPos pos = this.getEffectivePos().offset(i - 5, j - 5, k - 5);
                        BlockState state = this.getLevel().getBlockState(pos);
                        Block block = state.getBlock();
                        if (!(block instanceof CakeBlock)) continue;
                        int nextSlicesEaten = (Integer)state.getValue((Property)CakeBlock.BITES) + 1;
                        if (nextSlicesEaten > 6) {
                            this.getLevel().removeBlock(pos, false);
                        } else {
                            this.getLevel().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(nextSlicesEaten)));
                        }
                        this.getLevel().levelEvent(2001, pos, Block.getId((BlockState)state));
                        this.getLevel().gameEvent(null, (Holder)GameEvent.EAT, this.getEffectivePos());
                        this.getLevel().playSound(null, this.getEffectivePos(), SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                        this.addMana(mana);
                        this.sync();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 9657640;
    }

    @Override
    public int getMaxMana() {
        return 9001;
    }
}

