/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.generating.FluidGeneratorBlockEntity;

public class HydroangeasBlockEntity
extends FluidGeneratorBlockEntity {
    public static final String TAG_PASSIVE_DECAY_TICKS = "passiveDecayTicks";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    public static final int DECAY_TIME = 72000;
    private int passiveDecayTicks;

    public HydroangeasBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.HYDROANGEAS, pos, state, (TagKey<Fluid>)FluidTags.WATER, 40, 1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide && ++this.passiveDecayTicks > 72000) {
            this.getLevel().destroyBlock(this.getBlockPos(), false);
            if (Blocks.DEAD_BUSH.defaultBlockState().canSurvive((LevelReader)this.getLevel(), this.getBlockPos())) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), Blocks.DEAD_BUSH.defaultBlockState());
            }
        }
    }

    @Override
    public int getCooldownTime(boolean finishedPrevious) {
        return 0;
    }

    @Override
    public void doBurnParticles() {
        WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.05f, 0.05f, 0.7f, 1.0f);
        this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.55 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 60.0f, 0.0);
    }

    @Override
    public void playSound() {
        this.getLevel().playSound(null, this.getEffectivePos(), SoundEvents.GENERIC_DRINK, SoundSource.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    @Override
    public int getMaxMana() {
        return 150;
    }

    @Override
    public int getColor() {
        return 5451744;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.passiveDecayTicks = cmp.getInt(TAG_PASSIVE_DECAY_TICKS);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_PASSIVE_DECAY_TICKS, this.passiveDecayTicks);
    }

    @Override
    public int getGenerationDelay() {
        boolean rain = ((Biome)this.getLevel().getBiome(this.getEffectivePos()).value()).getPrecipitationAt(this.getEffectivePos()) == Biome.Precipitation.RAIN && (this.getLevel().isRaining() || this.getLevel().isThundering());
        return rain ? 2 : 3;
    }

    @Override
    public boolean isOvergrowthAffected() {
        return false;
    }
}

